/*
 * Decompiled with CFR 0.152.
 */
package com.dcfs.framework.sm.validate;

import com.dcfs.framework.sm.validate.PurviewValidatorInterface;
import com.dcfs.framework.sm.validate.TokenInterface;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PurviewValidatorImpl
implements PurviewValidatorInterface {
    private static Log log = LogFactory.getLog((Class)PurviewValidatorImpl.class);
    private SSOTokenManager manager;
    private AMStoreConnection amsc;
    private String username;
    private AMUser user;

    public boolean validate(HttpServletRequest request) {
        log.debug((Object)"\u8c03\u7528\u6743\u9650\u9a8c\u8bc1\u5f00\u59cb");
        TokenInterface token = (TokenInterface)request.getSession().getAttribute("token");
        log.debug((Object)"\u8c03\u7528\u6743\u9650\u9a8c\u8bc1\u5b9e\u73b0\u7c7b\uff1aPurviewValidatorImpl");
        String actionName = "";
        String serviceID = "";
        String authored = "";
        boolean is = false;
        String path = request.getServletPath();
        int dotIndex = path.indexOf(46);
        actionName = dotIndex > 0 ? path.substring(1, dotIndex) : path.substring(1);
        if (!actionName.equalsIgnoreCase("txDriver")) {
            return true;
        }
        String flagForService = request.getParameter("sys_head.SYS_trans_mode");
        serviceID = flagForService.equalsIgnoreCase("0") ? request.getParameter("app_head.app_trans_id") : request.getParameter("app_head.app_service_id");
        if (serviceID == null) {
            log.debug((Object)"\u65e0\u6cd5\u83b7\u53d6\u4ea4\u6613\u4ee3\u7801\u6216\u670d\u52a1\uff29\uff24\uff01");
            return false;
        }
        log.debug((Object)("\u8bf7\u6c42\u7684\u4ea4\u6613\u4ee3\u7801\u6216\u670d\u52a1\uff29\uff24\u4e3a\uff1a" + serviceID));
        try {
            if (request.getSession().getAttribute("authoredTran") == null || !this.isCompare((SSOToken)token.get(), (String)request.getSession().getAttribute("authoredTran"))) {
                authored = this.getAuthored((SSOToken)token.get());
                request.getSession().setAttribute("authoredTran", (Object)authored);
            }
        }
        catch (AMException e) {
            e.printStackTrace();
        }
        catch (SMSException e) {
            e.printStackTrace();
        }
        catch (SSOException e) {
            log.debug((Object)("\u6743\u9650\u9a8c\u8bc1SSOException\u5f02\u5e38\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        is = this.evaluate(request, serviceID);
        return is;
    }

    private boolean evaluate(HttpServletRequest request, String serviceID) {
        boolean result = false;
        String tranlist = (String)request.getSession().getAttribute("authoredTran");
        log.debug((Object)tranlist.substring(tranlist.lastIndexOf(":")));
        if (tranlist.substring(tranlist.lastIndexOf(":") + 1).equalsIgnoreCase("*")) {
            return true;
        }
        String[] tranSet = tranlist.split(":");
        for (int i = 0; i < tranSet.length; ++i) {
            if (!tranSet[i].equalsIgnoreCase(serviceID)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isCompare(SSOToken token, String authored) throws SSOException {
        String user = token.getPrincipal().getName();
        String userInauth = authored.substring(0, authored.indexOf(":"));
        log.debug((Object)("user::" + user));
        log.debug((Object)("userInauth::" + userInauth));
        return user.equalsIgnoreCase(userInauth);
    }

    private String getAuthored(SSOToken token) throws SSOException, AMException, SMSException {
        this.manager = SSOTokenManager.getInstance();
        String result = "";
        if (this.manager.isValidToken(token)) {
            this.amsc = new AMStoreConnection(token);
            this.username = token.getPrincipal().getName();
        }
        this.user = this.amsc.getUser(this.username);
        ServiceSchemaManager ssm = new ServiceSchemaManager("TransactionAuthorization", token);
        ServiceSchema sm = ssm.getSchema(SchemaType.DYNAMIC);
        if (sm != null) {
            Set userAttributeNames = sm.getAttributeSchemaNames();
            Map attributes = this.user.getAttributes(userAttributeNames);
            Set attrSet = (Set)attributes.get("dclservicetransactionauthored");
            result = (String)attrSet.toArray()[0];
        }
        String tmp = this.username + ":" + result;
        log.debug((Object)("authoredtran:" + tmp));
        return tmp;
    }
}

