/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.loading;

import com.dc.xml.loading.Load;
import com.dc.xml.loading.LoadListener;
import com.dc.xml.loading.LoadResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadManager
implements LoadListener {
    Log log = LogFactory.getLog((Class)LoadManager.class);
    List listerners = Collections.synchronizedList(new ArrayList());
    Map missions = Collections.synchronizedMap(new HashMap());
    static final LoadManager m = new LoadManager();

    public static LoadManager getInstance() {
        return m;
    }

    private LoadManager() {
        this.init();
    }

    public void init() {
        this.addLoadListener(this);
    }

    public void addLoadListener(LoadListener l) {
        this.listerners.add(l);
    }

    public void rmLoadListener(LoadListener l) {
        this.listerners.remove(l);
    }

    public void stopLoad(Load mission) {
        ((LoadResult)this.missions.get(mission)).interrupt();
        this.missions.remove(mission);
    }

    public void load(final Load mission) {
        final LoadResult result = new LoadResult(this.listerners);
        this.missions.put(mission, result);
        new Thread(new Runnable(){

            public void run() {
                mission.load(result);
            }
        });
    }

    public LoadResult loadSync(Load mission) {
        LoadResult result = new LoadResult(this.listerners);
        this.missions.put(mission, result);
        mission.load(result);
        return result;
    }

    public LoadResult loadSync(Load mission, LoadResult result) {
        for (int i = 0; i < this.listerners.size(); ++i) {
            result.addListener((LoadListener)this.listerners.get(i));
        }
        this.missions.put(mission, result);
        mission.load(result);
        return result;
    }

    public void addFailer(Load mission, Throwable th) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)("Load mission[" + mission + "] failed"), th);
        }
    }

    public void startLoad(Load mission) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)(mission + " started"));
        }
    }

    public void endLoad(Load mission) {
        LoadResult rv;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)(mission + " ended"));
        }
        if ((rv = (LoadResult)this.missions.remove(mission)) != null) {
            rv.clear();
        }
    }

    public static void loadMission(Load load) {
        LoadManager.getInstance().load(load);
    }

    public static void clear() {
        LoadManager.getInstance().listerners.clear();
        LoadManager.getInstance().listerners.add(m);
        LoadManager.getInstance().missions.clear();
    }
}

