/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.loading;

import com.dc.xml.loading.HaltableLoad;
import com.dc.xml.loading.Load;
import com.dc.xml.loading.LoadCase;
import com.dc.xml.loading.LoadSuite;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class LoadFactory {
    private static final FileFilter ff = new FileFilter(){

        public boolean accept(File pathname) {
            return !pathname.getName().equalsIgnoreCase("cvs");
        }
    };

    public static Load oneItrLoad(String uri, String url) throws Exception {
        File f = new File(new URL(url).getFile());
        LoadSuite load = new LoadSuite();
        load.setName(uri);
        String pattern = uri.substring(uri.lastIndexOf(58) + 1);
        if (!f.exists() || !f.isDirectory()) {
            throw new Exception(url + " not available");
        }
        File[] names = f.listFiles(ff);
        for (int j = 0; j < names.length; ++j) {
            if (!names[j].isDirectory() || !Pattern.matches(pattern, names[j].getName())) continue;
            StringBuffer buf = new StringBuffer(uri.substring(0, uri.lastIndexOf(58) + 1));
            buf.append(names[j].getName());
            load.addLoad(new HaltableLoad(new LoadCase(buf.toString())));
        }
        return new HaltableLoad(load);
    }

    public static Load twoItrLoad(String uri, String url) throws Exception {
        LoadSuite suite = new LoadSuite();
        File f = new File(new URL(url).getFile());
        StringTokenizer st = new StringTokenizer(uri, ":");
        String pt_system = null;
        String pt_item = null;
        StringBuffer uri_pre = new StringBuffer();
        do {
            String not_pt = pt_system;
            pt_system = pt_item;
            pt_item = st.nextToken();
            if (not_pt == null) continue;
            uri_pre.append(not_pt).append(':');
        } while (st.hasMoreTokens());
        if (!f.exists() || !f.isDirectory()) {
            throw new Exception(url + " is not available");
        }
        if (pt_system == null || pt_item == null) {
            throw new Exception(uri + " is not valid in towItrLoad");
        }
        File[] systems = f.listFiles(ff);
        for (int i = 0; i < systems.length; ++i) {
            if (!systems[i].isDirectory() || !Pattern.matches(pt_system, systems[i].getName())) continue;
            suite.addLoad(LoadFactory.singleLoad(uri_pre.toString() + systems[i].getName()));
            suite.addLoad(LoadFactory.oneItrLoad(uri_pre.toString() + systems[i].getName() + ":" + pt_item, systems[i].toURL().toString()));
        }
        return new HaltableLoad(suite);
    }

    public static Load singleLoad(String uri) throws Exception {
        LoadCase load = new LoadCase(uri);
        return new HaltableLoad(load);
    }
}

