/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.binding.rule;

import com.dc.xml.binding.rule.ExtRule;
import java.util.ArrayList;

public class PopRule
extends ExtRule {
    private int index;
    private boolean all = false;

    public PopRule() {
        this(0);
    }

    public PopRule(int index) {
        this.index = index;
    }

    public PopRule(int index, boolean all) {
        this.index = index;
        this.all = all;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean b) {
        this.all = b;
    }

    protected void work() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("****** pop stack(" + this.targetStack + ")index(" + this.index + ")******"));
        }
        if (this.index == 0) {
            this.pop();
        } else if (this.index > 0) {
            int i;
            ArrayList<Object> list = new ArrayList<Object>(this.index);
            Object top = null;
            for (i = 0; i < this.index; ++i) {
                top = this.pop();
                if (top == null) {
                    throw new IllegalArgumentException("Stack index out of bound");
                }
                list.add(top);
            }
            this.pop();
            for (i = this.index - 1; i >= 0; --i) {
                this.push(list.get(i));
            }
        }
        this.logStack();
    }

    protected String info() {
        return "pop " + this.targetStack + " at " + this.index;
    }
}

