/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.binding.rule;

import com.dc.xml.binding.IExtDigester;
import com.dc.xml.binding.rule.RuleException;
import java.util.HashMap;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public abstract class ExtRule
extends Rule {
    protected int pos = 1;
    protected Log log = LogFactory.getLog((String)ExtRule.class.getName());
    public static final String DEFAULT_STACK = "__extend__";
    public static final String BASE_STACK = "__base__";
    protected String targetStack;

    ExtRule(String targetStack) {
        this.targetStack = targetStack;
    }

    public ExtRule() {
        this(DEFAULT_STACK);
    }

    public Object pop() {
        if (this.targetStack == BASE_STACK) {
            return this.digester.pop();
        }
        return this.digester.pop(this.targetStack);
    }

    public void push(Object value) {
        if (this.targetStack == BASE_STACK) {
            this.digester.push(value);
        } else {
            this.digester.push(this.targetStack, value);
        }
    }

    public Object peek() {
        if (this.targetStack == BASE_STACK) {
            return this.digester.peek();
        }
        return this.digester.peek(this.targetStack);
    }

    public Object peek(int index) {
        if (this.targetStack == BASE_STACK) {
            return this.digester.peek(index);
        }
        Object o = null;
        if (this.digester instanceof IExtDigester) {
            return ((IExtDigester)this.digester).peek(this.targetStack, index);
        }
        throw new RuntimeException("Current digester do not support peekAttr method");
    }

    public String getTargetStack() {
        return this.targetStack;
    }

    public void setTargetStack(String string) {
        this.targetStack = string;
    }

    public HashMap peekAttr() {
        if (this.digester instanceof IExtDigester) {
            return ((IExtDigester)this.digester).peekAttr();
        }
        throw new RuntimeException("Current digester do not support peekAttr method");
    }

    public int getDepth(String stackName) {
        if (stackName == BASE_STACK) {
            stackName = null;
        }
        if (this.digester instanceof IExtDigester) {
            return ((IExtDigester)this.digester).getDepth(stackName);
        }
        throw new RuntimeException("Current digester do not support peekAttr method");
    }

    public int getDepth() {
        return this.getDepth(this.targetStack);
    }

    protected String stackInfo() {
        int depth = this.getDepth(this.targetStack);
        StringBuffer info = new StringBuffer();
        info.append(((Object)((Object)this)).getClass().getName()).append(" target stack: ").append(this.targetStack).append('\n');
        for (int i = 0; i < depth; ++i) {
            info.append("    ").append(this.peek(i)).append('\n');
        }
        return info.toString();
    }

    protected void logStack() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.stackInfo());
        }
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int i) {
        this.pos = i;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        super.begin(namespace, name, attributes);
        try {
            if (this.pos == 0) {
                this.work();
            }
        }
        catch (Throwable e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Error occured at Pos:[" + namespace + "," + this.digester.getMatch() + "," + ((IExtDigester)this.digester).peekAttr() + "] with Rule[" + this.info() + "]"), e);
                this.log.error((Object)this.stackInfo());
            }
            throw new RuleException("RuleWorkException", e);
        }
    }

    public void body(String namespace, String name, String text) throws Exception {
        super.body(namespace, name, text);
        try {
            if (this.pos == 1) {
                this.work();
            }
        }
        catch (Throwable e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Error occured at Pos:[" + namespace + "," + this.digester.getMatch() + "," + ((IExtDigester)this.digester).peekAttr() + "] with Rule[" + this.info() + "]"), e);
                this.log.error((Object)this.stackInfo());
            }
            throw new RuleException("RuleWorkException", e);
        }
    }

    public String getBodyText() {
        return ((IExtDigester)this.digester).getBodyText();
    }

    protected abstract void work() throws Exception;

    protected abstract String info();
}

