/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.binding.rule;

import com.dc.xml.binding.ExtRuleFactory;
import com.dc.xml.binding.rule.CpRule;
import com.dc.xml.binding.rule.DumpRule;
import com.dc.xml.binding.rule.DupRule;
import com.dc.xml.binding.rule.ExchangeRule;
import com.dc.xml.binding.rule.ExtRule;
import com.dc.xml.binding.rule.IfImplRule;
import com.dc.xml.binding.rule.InvokeChildRule;
import com.dc.xml.binding.rule.InvokeParentRule;
import com.dc.xml.binding.rule.ObjCreateRule;
import com.dc.xml.binding.rule.ObjInvokeRule;
import com.dc.xml.binding.rule.PopRule;
import com.dc.xml.binding.rule.PushAttrRule;
import com.dc.xml.binding.rule.PushContRule;
import com.dc.xml.binding.rule.PushValRule;
import com.dc.xml.binding.rule.RuleException;
import com.dc.xml.binding.rule.SetAttrRule;
import com.dc.xml.binding.rule.SetContRule;
import com.dc.xml.binding.rule.SetParentRule;
import com.dc.xml.binding.rule.SetValRule;
import com.dc.xml.binding.rule.StaInvokeRule;
import com.dc.xml.binding.rule.SwitchRule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.xmlrules.CircularIncludeException;
import org.apache.commons.digester.xmlrules.DigesterRuleParser;
import org.apache.commons.digester.xmlrules.DigesterRulesSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExtDigesterRuleParser
extends DigesterRuleParser {
    private Set includedFiles = new HashSet();
    public static final String DIGESTER_PUBLIC_ID_DIGITAL_CHINA = "-//DigitalChina//DTD digester-rules XML V1.0//EN";
    private int runAtPos = 1;

    public ExtDigesterRuleParser(Digester targetDigester) {
        super(targetDigester);
    }

    public ExtDigesterRuleParser() {
    }

    public void addRuleInstances(Digester digester) {
        super.addRuleInstances(digester);
        URL dtd = ((Object)((Object)this)).getClass().getResource("digester-rule_ext.dtd");
        if (null != dtd) {
            digester.register(DIGESTER_PUBLIC_ID_DIGITAL_CHINA, dtd.toString());
        }
        String ruleClassName = Rule.class.getName();
        digester.addFactoryCreate("*/push-value", (ObjectCreationFactory)new PushValRuleFactory());
        digester.addRule("*/push-value", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/push-value", "add", ruleClassName);
        digester.addFactoryCreate("*/push-attribute", (ObjectCreationFactory)new PushAttrRuleFactory());
        digester.addRule("*/push-attribute", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/push-attribute", "add", ruleClassName);
        digester.addFactoryCreate("*/push-content", (ObjectCreationFactory)new PushContRuleFactory());
        digester.addRule("*/push-content", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/push-content", "add", ruleClassName);
        digester.addFactoryCreate("*/pop", (ObjectCreationFactory)new PopRuleFactory());
        digester.addRule("*/pop", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/pop", "add", ruleClassName);
        digester.addFactoryCreate("*/dup", (ObjectCreationFactory)new DupRuleFactory());
        digester.addRule("*/dup", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/dup", "add", ruleClassName);
        digester.addFactoryCreate("*/xchg", (ObjectCreationFactory)new XchgRuleFactory());
        digester.addRule("*/xchg", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/xchg", "add", ruleClassName);
        digester.addFactoryCreate("*/cp", (ObjectCreationFactory)new CpRuleFactory());
        digester.addRule("*/cp", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/cp", "add", ruleClassName);
        digester.addFactoryCreate("*/create-object", (ObjectCreationFactory)new ObjCrtRuleFactory());
        digester.addRule("*/create-object", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/create-object", "add", ruleClassName);
        digester.addFactoryCreate("*/invoke-object", (ObjectCreationFactory)new ObjCallRuleFactory());
        digester.addRule("*/invoke-object", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/invoke-object", "add", ruleClassName);
        digester.addFactoryCreate("*/invoke-static", (ObjectCreationFactory)new StaCallRuleFactory());
        digester.addRule("*/invoke-static", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/invoke-static", "add", ruleClassName);
        digester.addFactoryCreate("*/invoke-parent", (ObjectCreationFactory)new InvokeParentFactory());
        digester.addRule("*/invoke-parent", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/invoke-parent", "add", ruleClassName);
        digester.addFactoryCreate("*/invoke-child", (ObjectCreationFactory)new InvokeChildFactory());
        digester.addRule("*/invoke-child", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/invoke-child", "add", ruleClassName);
        digester.addFactoryCreate("*/set-attribute", (ObjectCreationFactory)new SetAttrRuleFactory());
        digester.addRule("*/set-attribute", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/set-attribute", "add", ruleClassName);
        digester.addFactoryCreate("*/set-property", (ObjectCreationFactory)new SetValRuleFactory());
        digester.addRule("*/set-property", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/set-property", "add", ruleClassName);
        digester.addFactoryCreate("*/set-content", (ObjectCreationFactory)new SetContRuleFactory());
        digester.addRule("*/set-content", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/set-content", "add", ruleClassName);
        digester.addRule("*/begin", (Rule)new TagRunAtBeginRule());
        digester.addRule("*/end", (Rule)new TagRunAtBodyRule());
        digester.addFactoryCreate("*/if", (ObjectCreationFactory)new IfRuleFactory());
        digester.addRule("*/if", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/if", "add", ruleClassName);
        digester.addRule("*/include-url", (Rule)new IncludeRule());
        digester.addFactoryCreate("*/switch", (ObjectCreationFactory)new SwitchRuleFactory());
        digester.addRule("*/switch", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/switch", "add", ruleClassName);
        digester.addSetProperties("*/case", "value", "value");
        SetValRule1 rule1 = new SetValRule1("setBreak", null);
        digester.addRule("*/break", (Rule)rule1);
        SetValRule1 rule = new SetValRule1("value", "DEFAULT");
        digester.addRule("*/default", (Rule)rule);
        digester.addFactoryCreate("*/dump", (ObjectCreationFactory)new DumpRuleFactory());
        digester.addRule("*/dump", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/dump", "add", ruleClassName);
        digester.addFactoryCreate("*/set-parent", (ObjectCreationFactory)new SetParentRuleFactory());
        digester.addRule("*/set-parent", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/set-parent", "add", ruleClassName);
        digester.addFactoryCreate("*/if-not-null", (ObjectCreationFactory)new IfRuleFactory(true, true, false));
        digester.addRule("*/if-not-null", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/if-not-null", "add", ruleClassName);
        digester.addFactoryCreate("*/if-not-equal", (ObjectCreationFactory)new IfRuleFactory(true, false, false));
        digester.addRule("*/if-not-equal", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/if-not-equal", "add", ruleClassName);
        digester.addFactoryCreate("*/if-null", (ObjectCreationFactory)new IfRuleFactory(true, true, true));
        digester.addRule("*/if-null", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/if-null", "add", ruleClassName);
        digester.addFactoryCreate("*/if-equal", (ObjectCreationFactory)new IfRuleFactory(true, false, true));
        digester.addRule("*/if-equalt", (Rule)new PatternRule("pattern"));
        digester.addSetNext("*/if-equal", "add", ruleClassName);
    }

    public ExtDigesterRuleParser(Digester targetDigester, DigesterRuleParser.PatternStack patternStack, Set includedFiles) {
        this.targetDigester = targetDigester;
        this.patternStack = patternStack;
        this.includedFiles = includedFiles;
    }

    private class SetValRule1
    extends Rule {
        String prop;
        String value;

        public SetValRule1(String prop, String value) {
            this.prop = prop;
            this.value = value;
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            if (this.prop != null && this.value != null) {
                BeanUtils.setProperty((Object)this.digester.peek(), (String)this.prop, (Object)this.value);
            } else {
                Object[] o = null;
                if (this.value == null) {
                    o = new Object[]{};
                }
                MethodUtils.invokeExactMethod((Object)this.digester.peek(), (String)this.prop, (Object[])o);
            }
        }
    }

    public class SwitchRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            String attr_name = attributes.getValue("attr-name");
            String index = attributes.getValue("index");
            SwitchRule rule = null;
            if (attr_name != null) {
                rule = new SwitchRule(attr_name);
            }
            if (index != null) {
                rule.switch_index = Integer.parseInt(index);
            }
            rule.setDigester(ExtDigesterRuleParser.this.targetDigester);
            return rule;
        }
    }

    public class DumpRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            return new DumpRule();
        }
    }

    private class RulesPrefixAdapter
    implements Rules {
        private Rules delegate;
        private String prefix;

        public RulesPrefixAdapter(String patternPrefix, Rules rules) {
            this.prefix = patternPrefix;
            this.delegate = rules;
        }

        public void add(String pattern, Rule rule) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.prefix);
            if (pattern == null) {
                pattern = "";
            }
            if (pattern.length() > 0 && !pattern.startsWith("/")) {
                buffer.append('/');
            }
            buffer.append(pattern);
            this.delegate.add(buffer.toString(), rule);
        }

        public void clear() {
            this.delegate.clear();
        }

        public Digester getDigester() {
            return this.delegate.getDigester();
        }

        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI();
        }

        public List match(String pattern) {
            return this.delegate.match(pattern);
        }

        public List match(String namespaceURI, String pattern) {
            return this.delegate.match(namespaceURI, pattern);
        }

        public List rules() {
            return this.delegate.rules();
        }

        public void setDigester(Digester digester) {
            this.delegate.setDigester(digester);
        }

        public void setNamespaceURI(String namespaceURI) {
            this.delegate.setNamespaceURI(namespaceURI);
        }
    }

    private class IncludeRule
    extends Rule {
        public void begin(Attributes attributes) throws Exception {
            String url = attributes.getValue("url");
            String path = attributes.getValue("path");
            if (url != null && url.length() > 0) {
                this.includeXMLRules(url);
            } else if (path != null) {
                ClassLoader cl = ExtDigesterRuleParser.this.targetDigester.getClassLoader();
                URL fileURL = cl.getResource(path);
                if (fileURL == null) {
                    throw new IllegalStateException("Cannot find " + path + " in " + cl.toString());
                }
                this.includeXMLRules(fileURL.toString());
            }
            String className = attributes.getValue("class");
            if (className != null && className.length() > 0) {
                this.includeProgrammaticRules(className);
            }
        }

        private void includeXMLRules(String url) throws IOException, SAXException, CircularIncludeException {
            URL fileURL = new URL(url);
            if (fileURL == null) {
                throw new FileNotFoundException("URL \"" + url + "\" not found.");
            }
            if (!ExtDigesterRuleParser.this.includedFiles.add(url)) {
                throw new CircularIncludeException(url);
            }
            Digester digester = new Digester();
            digester.addRuleSet((RuleSet)ExtDigesterRuleParser.this);
            digester.push((Object)ExtDigesterRuleParser.this);
            InputStream in = null;
            try {
                in = fileURL.openStream();
                digester.parse(in);
            }
            catch (IOException e) {
                RuleException ex = new RuleException("IncludeFileError", e);
                ex.addScene("file", url);
                throw ex;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
            ExtDigesterRuleParser.this.includedFiles.remove(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void includeProgrammaticRules(String className) throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException {
            ClassLoader cl = ExtDigesterRuleParser.this.targetDigester.getClassLoader();
            Class<?> cls = Class.forName(className, true, cl);
            DigesterRulesSource rulesSource = (DigesterRulesSource)cls.newInstance();
            Rules digesterRules = ExtDigesterRuleParser.this.targetDigester.getRules();
            RulesPrefixAdapter prefixWrapper = new RulesPrefixAdapter(ExtDigesterRuleParser.this.patternStack.toString(), digesterRules);
            ExtDigesterRuleParser.this.targetDigester.setRules((Rules)prefixWrapper);
            try {
                rulesSource.getRules(ExtDigesterRuleParser.this.targetDigester);
            }
            finally {
                ExtDigesterRuleParser.this.targetDigester.setRules(digesterRules);
            }
        }
    }

    public class IfRuleFactory
    extends ExtRuleFactoryImp {
        boolean SwitchIsNull;
        boolean NullOrEqual;
        boolean specific;

        public IfRuleFactory(boolean specific, boolean SwitchIsNull, boolean NullOrEqual) {
            this.SwitchIsNull = true;
            this.NullOrEqual = true;
            this.specific = false;
            this.SwitchIsNull = SwitchIsNull;
            this.NullOrEqual = NullOrEqual;
            this.specific = specific;
        }

        public IfRuleFactory() {
            this.SwitchIsNull = true;
            this.NullOrEqual = true;
            this.specific = false;
        }

        public ExtRule createExtRule(Attributes attributes) throws Exception {
            String value = attributes.getValue("value");
            String value_name = attributes.getValue("value-name");
            String attr_name = attributes.getValue("attr-name");
            String index = attributes.getValue("index");
            String not = attributes.getValue("not");
            IfImplRule rule = new IfImplRule();
            if (this.specific) {
                if (attr_name != null) {
                    rule.switch_attr = attr_name;
                } else {
                    rule.null_index = Integer.parseInt(index);
                }
                if (!this.SwitchIsNull) {
                    rule.switch_value_name = value_name;
                    rule.switch_attr = attr_name;
                }
                if (!this.NullOrEqual) {
                    rule.not = true;
                }
            } else {
                rule.switch_value = value;
                rule.switch_value_name = value_name;
                rule.switch_attr = attr_name;
                if (not != null) {
                    rule.not = Boolean.valueOf(not);
                }
                if (index != null) {
                    rule.null_index = Integer.parseInt(index);
                }
            }
            rule.setDigester(ExtDigesterRuleParser.this.targetDigester);
            return rule;
        }
    }

    public class SetParentRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            String propName = attributes.getValue("prop-name");
            SetParentRule rule = new SetParentRule();
            rule.prop = propName;
            String str = null;
            str = attributes.getValue("parent-index");
            if (str != null) {
                rule.index = Integer.parseInt(str);
                str = null;
            }
            return rule;
        }
    }

    public class SetValRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            SetValRule excRule = null;
            String propName = attributes.getValue("prop-name");
            String value = attributes.getValue("value");
            excRule = new SetValRule(propName, value);
            String str = null;
            str = attributes.getValue("attr-name");
            if (str != null) {
                excRule.attrName = str;
                str = null;
            }
            if ((str = attributes.getValue("value-name")) != null) {
                excRule.valueName = str;
                str = null;
            }
            if ((str = attributes.getValue("index")) != null) {
                excRule.index = Integer.parseInt(str);
                str = null;
            }
            return excRule;
        }
    }

    public class SetContRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            SetContRule excRule = null;
            excRule = new SetContRule();
            String str = null;
            str = attributes.getValue("prop-name");
            if (str != null) {
                excRule.propName = str;
                str = null;
            }
            if ((str = attributes.getValue("attr-name")) != null) {
                excRule.attrName = str;
                str = null;
            }
            return excRule;
        }
    }

    public class SetAttrRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            SetAttrRule excRule = null;
            String attrName = attributes.getValue("attr-name");
            String propName = attributes.getValue("prop-name");
            if (propName == null) {
                propName = attrName;
            }
            excRule = new SetAttrRule(attrName, propName);
            return excRule;
        }
    }

    public class InvokeChildFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            InvokeChildRule excRule = null;
            String methodName = attributes.getValue("method-name");
            String parentIndex = attributes.getValue("parent-index");
            int index = 1;
            if (parentIndex != null) {
                index = Integer.parseInt(parentIndex);
            }
            excRule = new InvokeChildRule(methodName, index);
            return excRule;
        }
    }

    public class InvokeParentFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            InvokeParentRule excRule = null;
            String methodName = attributes.getValue("method-name");
            String parentIndex = attributes.getValue("parent-index");
            int index = 1;
            if (parentIndex != null) {
                index = Integer.parseInt(parentIndex);
            }
            excRule = new InvokeParentRule(methodName, index);
            return excRule;
        }
    }

    private class TagRunAtBodyRule
    extends Rule {
        private TagRunAtBodyRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            super.begin(namespace, name, attributes);
            ExtDigesterRuleParser.this.runAtPos = 1;
        }

        public void body(String namespace, String name, String text) throws Exception {
            super.body(namespace, name, text);
            ExtDigesterRuleParser.this.runAtPos = 1;
        }
    }

    private class TagRunAtBeginRule
    extends Rule {
        private TagRunAtBeginRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            super.begin(namespace, name, attributes);
            ExtDigesterRuleParser.this.runAtPos = 0;
        }

        public void body(String namespace, String name, String text) throws Exception {
            super.body(namespace, name, text);
            ExtDigesterRuleParser.this.runAtPos = 1;
        }
    }

    private class PatternRule
    extends Rule {
        private String attrName;
        private String pattern = null;

        public PatternRule(String attrName) {
            this.attrName = attrName;
        }

        public void begin(Attributes attributes) {
            this.pattern = attributes.getValue(this.attrName);
            if (this.pattern != null) {
                ExtDigesterRuleParser.this.patternStack.push((Object)this.pattern);
            }
        }

        public void end() {
            if (this.pattern != null) {
                ExtDigesterRuleParser.this.patternStack.pop();
            }
        }
    }

    public class PushAttrRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            PushAttrRule excRule = null;
            String attrName = attributes.getValue("attr-name");
            excRule = new PushAttrRule(attrName);
            excRule.setValue(attributes.getValue("default-value"));
            return excRule;
        }
    }

    public class StaCallRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            StaInvokeRule excRule = null;
            String className = attributes.getValue("class-name");
            String methodName = attributes.getValue("method-name");
            String paraCount = attributes.getValue("param-count");
            excRule = paraCount == null ? new StaInvokeRule(className, methodName, 0) : new StaInvokeRule(className, methodName, Integer.parseInt(paraCount));
            return excRule;
        }
    }

    public class ObjCallRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            ObjInvokeRule excRule = null;
            String methodName = attributes.getValue("method-name");
            String paraCount = attributes.getValue("param-count");
            excRule = paraCount == null ? new ObjInvokeRule(methodName, 0) : new ObjInvokeRule(methodName, Integer.parseInt(paraCount));
            return excRule;
        }
    }

    public class ObjCrtRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            ObjCreateRule excRule = null;
            String className = attributes.getValue("class-name");
            String paraCount = attributes.getValue("param-count");
            excRule = paraCount == null ? new ObjCreateRule(className, 0) : new ObjCreateRule(className, Integer.parseInt(paraCount));
            return excRule;
        }
    }

    public class CpRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            CpRule excRule = null;
            String source = attributes.getValue("source");
            excRule = new CpRule(source);
            return excRule;
        }
    }

    public class PushContRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            PushContRule excRule = null;
            excRule = new PushContRule();
            return excRule;
        }
    }

    public class XchgRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            ExchangeRule excRule = null;
            String from = attributes.getValue("from-index");
            String to = attributes.getValue("to-index");
            excRule = from == null || to == null ? new ExchangeRule() : new ExchangeRule(Integer.parseInt(from), Integer.parseInt(to));
            return excRule;
        }
    }

    public class DupRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            DupRule dupRule = null;
            String index = attributes.getValue("index");
            dupRule = index == null ? new DupRule() : new DupRule(Integer.parseInt(index));
            return dupRule;
        }
    }

    public class PushValRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            PushValRule pushRule = null;
            String value = attributes.getValue("value");
            pushRule = new PushValRule(value);
            return pushRule;
        }
    }

    public class PopRuleFactory
    extends ExtRuleFactoryImp {
        public ExtRule createExtRule(Attributes attributes) throws Exception {
            PopRule popRule = null;
            String index = attributes.getValue("index");
            String all = attributes.getValue("all");
            popRule = index == null ? new PopRule() : (all != null ? new PopRule(Integer.parseInt(index), Boolean.valueOf(all)) : new PopRule(Integer.parseInt(index)));
            return popRule;
        }
    }

    public abstract class ExtRuleFactoryImp
    extends ExtRuleFactory {
        public int getRunPos() {
            return ExtDigesterRuleParser.this.runAtPos;
        }
    }
}

