/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.binding.db;

import com.dc.util.xml.CommonData;
import java.util.Iterator;
import java.util.Stack;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class CmDataReader {
    DefaultHandler handler;
    Stack s = new Stack();

    public void parse(CommonData data) throws SAXException {
        if (data.getParent() == null) {
            this.handler.startDocument();
            this.s.push(data.getName());
        }
        try {
            AttributesImpl attr = new AttributesImpl();
            Iterator itr = data.attributeNames();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                attr.addAttribute(null, data.getName(), key, null, (String)data.getAttribute(key));
            }
            this.handler.startElement(null, data.getName(), null, attr);
        }
        catch (Exception e) {
            this.handler.error(new SAXParseException("exception occured in startElement of data:" + this.getPosInfo(), null, null, 0, 0, e));
        }
        for (int i = 0; i < data.childCount(); ++i) {
            CommonData child = data.getChild(i);
            this.s.push("child[" + i + "],name(" + child.getName() + ")");
            this.parse(child);
            this.s.pop();
        }
        try {
            this.handler.endElement(null, data.getName(), null);
            if (data.getParent() == null) {
                this.handler.endDocument();
                this.s.pop();
            }
        }
        catch (Exception e) {
            this.handler.error(new SAXParseException("exception occured in endElement of data:" + this.getPosInfo(), null, null, 0, 0, e));
        }
    }

    private String getPosInfo() {
        StringBuffer info = new StringBuffer();
        for (int i = 0; i < this.s.size(); ++i) {
            info.append((String)this.s.get(i)).append('\n');
        }
        return info.toString();
    }
}

