/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.binding;

import com.dc.xml.binding.ConfigException;
import com.dc.xml.binding.ExtDigester;
import com.dc.xml.binding.InStreamFactory;
import com.dc.xml.binding.rule.ExtDigesterRuleParser;
import com.dc.xml.binding.rule.RuleException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RegexMatcher;
import org.apache.commons.digester.RegexRules;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.SimpleRegexMatcher;
import org.apache.commons.digester.xmlrules.DigesterRuleParser;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExtDigesterHelper {
    static final Log log = LogFactory.getLog((Class)ExtDigesterHelper.class);

    public static Digester createDigester(InputSource rulesSource) {
        return ExtDigesterHelper.createDigester(rulesSource, new Digester());
    }

    public static Digester createDigester(InputSource rulesSource, Digester rulesDigester) {
        FromXmlRuleSet ruleSet = new FromXmlRuleSet(rulesSource, rulesDigester);
        ExtDigester digester = new ExtDigester();
        digester.setRules((Rules)new RegexRules((RegexMatcher)new SimpleRegexMatcher()));
        digester.addRuleSet((RuleSet)ruleSet);
        return digester;
    }

    public static Digester createDigester(URL rulesXml) {
        return ExtDigesterHelper.createDigester(rulesXml, new Digester());
    }

    public static Digester createDigester(URL rulesXml, Digester rulesDigester) {
        ExtDigester digester = new ExtDigester();
        digester.setClassLoader(rulesDigester.getClassLoader());
        digester.setRules((Rules)new RegexRules((RegexMatcher)new SimpleRegexMatcher()));
        FromXmlRuleSet ruleSet = new FromXmlRuleSet(rulesXml, (DigesterRuleParser)new ExtDigesterRuleParser(), rulesDigester);
        digester.addRuleSet((RuleSet)ruleSet);
        return digester;
    }

    public static Object load(URL digesterRules, ClassLoader classLoader, InputStream input) throws ConfigException {
        if (digesterRules == null) {
            throw new IllegalArgumentException("rule cannot be null");
        }
        Digester digester = null;
        if (classLoader != null) {
            Digester ruleParser = new Digester();
            ruleParser.setClassLoader(classLoader);
            digester = ExtDigesterHelper.createDigester(digesterRules, ruleParser);
        } else {
            digester = ExtDigesterHelper.createDigester(digesterRules);
        }
        digester.setValidating(false);
        digester.setClassLoader(classLoader);
        ConfigException ce = null;
        try {
            return digester.parse(input);
        }
        catch (RuleException e) {
            return null;
        }
        catch (IOException e) {
            throw new ConfigException("ConfigFileIOException", e);
        }
        catch (SAXException e) {
            ce = new ConfigException("SaxParseException", e);
            throw ce;
        }
    }

    public static Object load(URL digesterRules, ClassLoader classLoader, InputStream input, Object rootObject) throws ConfigException {
        if (digesterRules == null) {
            throw new IllegalArgumentException("rule cannot be null");
        }
        Digester digester = null;
        if (classLoader != null) {
            Digester ruleParser = new Digester();
            ruleParser.setClassLoader(classLoader);
            digester = ExtDigesterHelper.createDigester(digesterRules, ruleParser);
        } else {
            digester = ExtDigesterHelper.createDigester(digesterRules);
        }
        digester.setClassLoader(classLoader);
        digester.push(rootObject);
        try {
            return digester.parse(input);
        }
        catch (XmlLoadException e) {
            ConfigException ce = new ConfigException("DigesterParseException", e);
            ce.addScene("digester error", e.getMessage());
            throw ce;
        }
        catch (IOException e) {
            throw new ConfigException("ConfigFileIOException", e);
        }
        catch (SAXException e) {
            ConfigException ce = new ConfigException("SaxParseException", e);
            throw ce;
        }
    }

    public static Object load(URL digesterRules, ClassLoader classLoader, Reader reader) throws ConfigException {
        Digester digester = null;
        if (classLoader != null) {
            Digester ruleParser = new Digester();
            ruleParser.setClassLoader(classLoader);
            digester = ExtDigesterHelper.createDigester(digesterRules, ruleParser);
        } else {
            digester = ExtDigesterHelper.createDigester(digesterRules);
        }
        digester.setClassLoader(classLoader);
        try {
            return digester.parse(reader);
        }
        catch (XmlLoadException e) {
            ConfigException ce = new ConfigException("DigesterParseException", e);
            ce.addScene("digester error", e.getMessage());
            throw ce;
        }
        catch (IOException e) {
            throw new ConfigException("ConfigFileIOException", e);
        }
        catch (SAXException e) {
            ConfigException ce = new ConfigException("SaxParseException", e);
            ce.addScene("sax error", e.getMessage());
            throw ce;
        }
    }

    public static Object load(URL digesterRules, ClassLoader classLoader, Reader input, Object rootObject) throws ConfigException {
        Digester digester = null;
        if (classLoader != null) {
            Digester ruleParser = new Digester();
            ruleParser.setClassLoader(classLoader);
            digester = ExtDigesterHelper.createDigester(digesterRules, ruleParser);
        } else {
            digester = ExtDigesterHelper.createDigester(digesterRules);
        }
        digester.setClassLoader(classLoader);
        digester.push(rootObject);
        try {
            return digester.parse(input);
        }
        catch (XmlLoadException e) {
            ConfigException ce = new ConfigException("DigesterParseException", e);
            ce.addScene("digester error", e.getMessage());
            throw ce;
        }
        catch (IOException e) {
            throw new ConfigException("ConfigFileIOException", e);
        }
        catch (SAXException e) {
            ConfigException ce = new ConfigException("SaxParseException", e);
            ce.addScene("sax error", e.getMessage());
            throw ce;
        }
    }

    public static Object load(URL digesterRules, ClassLoader classLoader, URL fileURL) throws ConfigException {
        if (digesterRules == null || fileURL == null) {
            throw new IllegalArgumentException("rule or config cannot be null");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("#Begin use " + digesterRules + " loading " + fileURL));
        }
        InputStream in = null;
        try {
            in = fileURL.openStream();
            Object object = ExtDigesterHelper.load(digesterRules, classLoader, in);
            return object;
        }
        catch (ConfigException e) {
            e.addScene("rule,data", "" + digesterRules + "," + fileURL);
            throw e;
        }
        catch (IOException e) {
            ConfigException ce = new ConfigException("FileCannotOpen", e);
            ce.addScene("rule,data", "" + digesterRules + "," + fileURL);
            log.error((Object)(fileURL + "\u88c5\u8f7d\u5931\u8d25"), (Throwable)e);
            throw ce;
        }
        catch (Exception e) {
            ConfigException ce = new ConfigException("UnknownError", e);
            ce.addScene("rule,data", "" + digesterRules + "," + fileURL);
            log.error((Object)(fileURL + "\u88c5\u8f7d\u5931\u8d25"), (Throwable)e);
            throw ce;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static Object load(URL digesterRules, ClassLoader classLoader, URL fileURL, Object rootObject) throws ConfigException {
        if (digesterRules == null || fileURL == null) {
            throw new IllegalArgumentException("rule or config cannot be null, rule[" + digesterRules + "],data[" + fileURL + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("#Begin use " + digesterRules + " loading " + fileURL));
        }
        try {
            return ExtDigesterHelper.load(digesterRules, classLoader, InStreamFactory.getInstance().openStream(fileURL), rootObject);
        }
        catch (IOException e) {
            ConfigException ce = new ConfigException("FileCannotOpen", e);
            ce.addScene("file", fileURL);
            throw ce;
        }
    }
}

