/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.binding;

import com.dc.xml.binding.URIMap;
import java.net.URI;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultURIMap
implements URIMap {
    String uriPattern;
    String ruleUrl;
    String dataUrl;

    public boolean match(URI uri) {
        Pattern pattern = Pattern.compile(this.uriPattern);
        return pattern.matcher(uri.toString()).matches();
    }

    protected String uri2path(String url_pattern, URI uri) {
        StringTokenizer stk = new StringTokenizer(uri.getSchemeSpecificPart(), ":/");
        String[] tokens = new String[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreTokens()) {
            tokens[i] = stk.nextToken();
            ++i;
        }
        String patternStr = "(\\$\\{[0-9]{1,}\\})";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(url_pattern);
        StringBuffer buf = new StringBuffer();
        boolean found = false;
        while (found = matcher.find()) {
            String replaceStr = matcher.group();
            int index = Integer.parseInt(replaceStr.substring(replaceStr.indexOf(123) + 1, replaceStr.lastIndexOf(125)));
            replaceStr = tokens[index];
            matcher.appendReplacement(buf, replaceStr);
        }
        matcher.appendTail(buf);
        String result = buf.toString();
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DefaultURIMap)) {
            return false;
        }
        return ((DefaultURIMap)o).uriPattern.equals(this.uriPattern);
    }

    public String getRuleUrl() {
        return this.ruleUrl;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setRuleUrl(String string) {
        if (string == null) {
            throw new IllegalArgumentException("RuleURL cannot be null");
        }
        this.ruleUrl = string;
    }

    public void setUriPattern(String string) {
        if (string == null) {
            throw new IllegalArgumentException("UriPattern cannot be null");
        }
        this.uriPattern = string;
    }

    public String getRulePath() {
        return this.ruleUrl;
    }

    public String getDataPath(URI uri) {
        return this.uri2path(this.dataUrl, uri);
    }

    public String getRulePath(URI uri) {
        return this.uri2path(this.ruleUrl, uri);
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String string) {
        if (string == null) {
            throw new IllegalArgumentException("DataURL cannot be null");
        }
        this.dataUrl = string;
    }
}

