/*
 * Decompiled with CFR 0.152.
 */
package com.dc.xml.binding;

import com.dc.util.xml.CommonData;
import com.dc.xml.binding.ConfigException;
import com.dc.xml.binding.db.CmDataDigester;
import com.dc.xml.binding.rule.ExtDigesterRuleParser;
import com.dc.xml.binding.rule.RuleException;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RegexMatcher;
import org.apache.commons.digester.RegexRules;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.SimpleRegexMatcher;
import org.apache.commons.digester.xmlrules.DigesterRuleParser;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.xml.sax.SAXException;

public class CmDataDigesterHelper {
    public static CmDataDigester createDigester(URL rulesXml) {
        return CmDataDigesterHelper.createDigester(rulesXml, new Digester());
    }

    public static CmDataDigester createDigester(URL rulesXml, Digester rulesDigester) {
        CmDataDigester digester = new CmDataDigester();
        digester.setRules((Rules)new RegexRules((RegexMatcher)new SimpleRegexMatcher()));
        FromXmlRuleSet ruleSet = new FromXmlRuleSet(rulesXml, (DigesterRuleParser)new ExtDigesterRuleParser(), rulesDigester);
        digester.addRuleSet((RuleSet)ruleSet);
        return digester;
    }

    public static Object load(URL digesterRules, ClassLoader classLoader, CommonData data) throws ConfigException {
        CmDataDigester digester = CmDataDigesterHelper.createDigester(digesterRules);
        digester.setClassLoader(classLoader);
        ConfigException ce = null;
        try {
            return digester.parse(data);
        }
        catch (RuleException e) {
            return null;
        }
        catch (SAXException e) {
            ce = new ConfigException("SaxParseException", e);
            throw ce;
        }
    }
}

