/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.xml.store;

import com.dc.util.xml.CommonData;
import com.dc.util.xml.CommonDataHelper;
import com.dc.util.xml.store.SaxHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLoader {
    private static SAXParserFactory factory;
    private static XMLReader parser;
    private static SaxHandler handler;

    public static void load(CommonData root, File file) {
        int length = (int)file.length();
        byte[] buff = new byte[length];
        try {
            FileInputStream in = new FileInputStream(file);
            in.read(buff);
            XMLoader.load(root, buff);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File [" + file.getAbsolutePath() + "] not exist!");
        }
        catch (IOException e) {
            throw new RuntimeException("Read [" + file.getAbsolutePath() + "] error!");
        }
    }

    public static void load(CommonData root, Reader in) {
        InputSource is = new InputSource(in);
        handler.setRoot(root);
        try {
            parser.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Parse xml error!");
        }
    }

    public static void load(CommonData root, InputStream in) {
        InputSource is = new InputSource(in);
        handler.setRoot(root);
        try {
            parser.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Parse xml error!");
        }
    }

    public static void load(CommonData root, byte[] buff) {
        XMLoader.load(root, new String(buff));
    }

    public static void load(CommonData root, char[] buff) {
        XMLoader.load(root, new String(buff));
    }

    public static void load(CommonData root, String buff) {
        InputSource is = new InputSource(new StringReader(buff));
        handler.setRoot(root);
        try {
            parser.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Parse xml error!");
        }
    }

    public static void store(CommonData root, OutputStream out) {
        try {
            XMLoader.store(root, new OutputStreamWriter(out, System.getProperty("file.encoding")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void store(CommonData root, Writer out) {
        try {
            out.write(CommonDataHelper.toXMLString(root));
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        try {
            factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            parser = factory.newSAXParser().getXMLReader();
            handler = new SaxHandler();
            parser.setDTDHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(handler);
            parser.setContentHandler(handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("No valid sax parser!");
        }
    }
}

