/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.xml.store;

import com.dc.exception.SystemException;
import com.dc.util.xml.CommonData;
import com.dc.util.xml.CommonDataHelper;
import com.dc.util.xml.store.SaxHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLConverter {
    private static SAXParserFactory factory = SAXParserFactory.newInstance();
    private XMLReader parser;
    private SaxHandler handler;

    public void load(CommonData root, File file) {
        int length = (int)file.length();
        byte[] buff = new byte[length];
        try {
            FileInputStream in = new FileInputStream(file);
            in.read(buff);
            this.load(root, buff);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File [" + file.getAbsolutePath() + "] not exist!");
        }
        catch (IOException e) {
            throw new RuntimeException("Read [" + file.getAbsolutePath() + "] error!");
        }
    }

    public void load(CommonData root, Reader in) {
        InputSource is = new InputSource(in);
        this.handler.setRoot(root);
        try {
            this.parser.parse(is);
        }
        catch (Exception e) {
            SystemException se = new SystemException("parse_xml_error");
            se.addScene("msg", "Parse xml error!");
            se.addScene("exception", e);
            throw se;
        }
    }

    public void load(CommonData root, InputStream in) {
        InputSource is = new InputSource(in);
        this.handler.setRoot(root);
        try {
            this.parser.parse(is);
        }
        catch (Exception e) {
            SystemException se = new SystemException("parse_xml_error");
            se.addScene("msg", "Parse xml error!");
            se.addScene("exception", e);
            throw se;
        }
    }

    public void load(CommonData root, byte[] buff) {
        try {
            this.load(root, new String(buff, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void load(CommonData root, char[] buff) {
        this.load(root, new String(buff));
    }

    public void load(CommonData root, String buff) {
        InputSource is = new InputSource(new StringReader(buff));
        this.handler.setRoot(root);
        try {
            this.parser.parse(is);
        }
        catch (Exception e) {
            SystemException se = new SystemException("parse_xml_error");
            se.addScene("msg", "Parse xml error!");
            se.addScene("exception", e);
            throw se;
        }
    }

    public void store(CommonData root, OutputStream out) {
        byte[] buff = CommonDataHelper.toXMLString(root).getBytes();
        try {
            out.write(buff);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void store(CommonData root, Writer out) {
        try {
            out.write(CommonDataHelper.toXMLString(root));
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public XMLConverter() {
        try {
            this.parser = factory.newSAXParser().getXMLReader();
            this.handler = new SaxHandler();
            this.parser.setDTDHandler(this.handler);
            this.parser.setEntityResolver(this.handler);
            this.parser.setErrorHandler(this.handler);
            this.parser.setContentHandler(this.handler);
        }
        catch (Exception e) {
            SystemException se = new SystemException("no_valid_saxparser");
            se.addScene("msg", "No valid sax parser!");
            se.addScene("exception", e);
            throw se;
        }
    }

    static {
        factory.setValidating(false);
    }
}

