/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.xml;

import com.dc.util.xml.CommonData;
import java.util.Iterator;

public final class CommonDataHelper {
    private static String[][] tmp = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"'", "&apos;"}, {"\"", "&quot;"}};

    public static String toXMLString(CommonData data) {
        StringBuffer buff = new StringBuffer(256);
        if (data.childCount() == 1) {
            buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            CommonDataHelper.toXMLString(data.getChild(0), buff);
            return buff.toString();
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    }

    private static void toXMLString(CommonData data, StringBuffer buff) {
        String name = data.getName();
        String value = (String)data.getValue();
        buff.append("<").append(name);
        Iterator it = data.attributeNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String attrValue = (String)data.getAttribute(key);
            buff.append(" ").append(key).append("=\"").append(attrValue).append("\"");
        }
        int count = data.childCount();
        if (count > 0) {
            buff.append(">\n");
            for (int i = 0; i < count; ++i) {
                CommonData child = data.getChild(i);
                CommonDataHelper.toXMLString(child, buff);
            }
            buff.append("</").append(name).append(">\n");
        } else if (value != null && value.length() > 0) {
            value = CommonDataHelper.replaceXML(value);
            buff.append(">").append(value);
            buff.append("</").append(name).append(">\n");
        } else {
            buff.append("/>\n");
        }
    }

    private static String replaceXML(String value) {
        int i;
        String st = "";
        for (i = 0; i < tmp.length; ++i) {
            st = tmp[i][1].replace("&", "#");
            value = value.replaceAll(tmp[i][1], st);
        }
        for (i = 0; i < tmp.length; ++i) {
            st = tmp[i][1].replace("&", "#");
            value = value.replaceAll(tmp[i][0], tmp[i][1]);
            value = value.replaceAll(st, tmp[i][1]);
        }
        return value;
    }
}

