/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.reflect;

import com.dc.util.bean.PropertyUtilException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ConstructorUtils {
    private static final Map _primitiveMap = new HashMap();

    private ConstructorUtils() {
    }

    public static Object invokeConstructor(Class targetClass, Object[] parameters) {
        if (parameters == null) {
            parameters = new Object[]{};
        }
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        return ConstructorUtils.invokeMatchingConstructor(targetClass, parameterTypes, parameters);
    }

    private static Object invokeMatchingConstructor(Class targetClass, Class[] parameterTypes, Object[] parameters) {
        Constructor<?>[] constructors = targetClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (!ConstructorUtils.isMatch(c, parameterTypes)) continue;
            return ConstructorUtils.invoke(c, parameters);
        }
        PropertyUtilException e = new PropertyUtilException("no-match-constructor");
        throw e;
    }

    private static boolean isMatch(Constructor c, Class[] types) {
        Class<?>[] actualTypes = c.getParameterTypes();
        if (actualTypes.length != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null && actualTypes[i].isPrimitive() || ConstructorUtils.isCompatible(actualTypes[i], types[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isCompatible(Class actualType, Class parameterType) {
        if (actualType.isAssignableFrom(parameterType)) {
            return true;
        }
        if (actualType.isPrimitive()) {
            Class wrapperClass = (Class)_primitiveMap.get(actualType);
            return wrapperClass.isAssignableFrom(parameterType);
        }
        return false;
    }

    private static Object invoke(Constructor c, Object[] parameters) {
        try {
            return c.newInstance(parameters);
        }
        catch (Exception ex) {
            PropertyUtilException e = new PropertyUtilException("invoke-constructor-fail", ex);
            throw e;
        }
    }

    static {
        _primitiveMap.put(Boolean.TYPE, Boolean.class);
        _primitiveMap.put(Byte.TYPE, Byte.class);
        _primitiveMap.put(Character.TYPE, Character.class);
        _primitiveMap.put(Short.TYPE, Short.class);
        _primitiveMap.put(Integer.TYPE, Integer.class);
        _primitiveMap.put(Long.TYPE, Long.class);
        _primitiveMap.put(Float.TYPE, Float.class);
        _primitiveMap.put(Double.TYPE, Double.class);
    }
}

