/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.pack;

import com.dc.util.pack.ConvertException;
import java.io.UnsupportedEncodingException;

public final class PackUtils {
    private PackUtils() {
    }

    public static byte get_int8(byte[] buff, int current) {
        return buff[current];
    }

    public static void put_int8(byte[] buff, int current, int value) {
        buff[current] = (byte)value;
    }

    public static void put_int8(byte[] buff, int current, short value) {
        buff[current] = (byte)value;
    }

    public static void put_int8(byte[] buff, int current, byte value) {
        buff[current] = value;
    }

    public static short get_int16(byte[] buff, int current) {
        return PackUtils.get_int16(buff, current, true);
    }

    public static short get_int16(byte[] buff, int current, boolean netorder) {
        int b1 = buff[current];
        int b2 = buff[current + 1];
        if (b1 < 0) {
            b1 += 256;
        }
        if (b2 < 0) {
            b2 += 256;
        }
        if (netorder) {
            return (short)((b1 << 8) + b2);
        }
        return (short)((b2 << 8) + b1);
    }

    public static void put_int16(byte[] buff, int current, int value) {
        PackUtils.put_int16(buff, current, value, true);
    }

    public static void put_int16(byte[] buff, int current, int value, boolean netorder) {
        short s = (short)value;
        PackUtils.put_int16(buff, current, s, netorder);
    }

    public static void put_int16(byte[] buff, int current, short value) {
        PackUtils.put_int16(buff, current, value, true);
    }

    public static void put_int16(byte[] buff, int current, short value, boolean netorder) {
        byte b1 = (byte)(value >> 8);
        byte b2 = (byte)(value & 0xFF);
        if (netorder) {
            buff[current] = b1;
            buff[current + 1] = b2;
        } else {
            buff[current] = b2;
            buff[current + 1] = b1;
        }
    }

    public static int get_int24(byte[] buff, int current) {
        return PackUtils.get_int24(buff, current, true);
    }

    public static int get_int24(byte[] buff, int current, boolean netorder) {
        int b1 = buff[current];
        int b2 = buff[current + 1];
        int b3 = buff[current + 2];
        if (b1 < 0) {
            b1 += 256;
        }
        if (b2 < 0) {
            b2 += 256;
        }
        if (b3 < 0) {
            b3 += 256;
        }
        if (netorder) {
            return (b1 << 16) + (b2 << 8) + b3;
        }
        return (b3 << 16) + (b2 << 8) + b1;
    }

    public static void put_int24(byte[] buff, int current, int value) {
        PackUtils.put_int24(buff, current, value, true);
    }

    public static void put_int24(byte[] buff, int current, int value, boolean netorder) {
        byte b1 = (byte)(value >> 16);
        byte b2 = (byte)((value & 0xFF00) >> 8);
        byte b3 = (byte)(value & 0xFF);
        if (netorder) {
            buff[current] = b1;
            buff[current + 1] = b2;
            buff[current + 2] = b3;
        } else {
            buff[current] = b3;
            buff[current + 1] = b2;
            buff[current + 2] = b1;
        }
    }

    public static int get_int32(byte[] buff, int current) {
        return PackUtils.get_int32(buff, current, true);
    }

    public static int get_int32(byte[] buff, int current, boolean netorder) {
        int b1 = buff[current];
        int b2 = buff[current + 1];
        int b3 = buff[current + 2];
        int b4 = buff[current + 3];
        if (b1 < 0) {
            b1 += 256;
        }
        if (b2 < 0) {
            b2 += 256;
        }
        if (b3 < 0) {
            b3 += 256;
        }
        if (b4 < 0) {
            b4 += 256;
        }
        if (netorder) {
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        }
        return (b4 << 24) + (b3 << 16) + (b2 << 8) + b1;
    }

    public static void put_int32(byte[] buff, int current, int value) {
        PackUtils.put_int32(buff, current, value, true);
    }

    public static void put_int32(byte[] buff, int current, int value, boolean netorder) {
        byte b1 = (byte)(value >> 24);
        byte b2 = (byte)((value & 0xFF0000) >> 16);
        byte b3 = (byte)((value & 0xFF00) >> 8);
        byte b4 = (byte)(value & 0xFF);
        if (netorder) {
            buff[current] = b1;
            buff[current + 1] = b2;
            buff[current + 2] = b3;
            buff[current + 3] = b4;
        } else {
            buff[current] = b4;
            buff[current + 1] = b3;
            buff[current + 2] = b2;
            buff[current + 3] = b1;
        }
    }

    public static long get_int64(byte[] buff, int current) {
        return PackUtils.get_int64(buff, current, true);
    }

    public static long get_int64(byte[] buff, int current, boolean netorder) {
        long l1 = PackUtils.get_int32(buff, current, netorder);
        long l2 = PackUtils.get_int32(buff, current + 4, netorder);
        if (netorder) {
            return (l1 << 32) + l2;
        }
        return (l2 << 32) + l1;
    }

    public static void put_int64(byte[] buff, int current, long value) {
        PackUtils.put_int64(buff, current, value, true);
    }

    public static void put_int64(byte[] buff, int current, long value, boolean netorder) {
        int i1 = (int)(value >> 32);
        int i2 = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        if (netorder) {
            PackUtils.put_int32(buff, current, i1, netorder);
            PackUtils.put_int32(buff, current + 4, i2, netorder);
        } else {
            PackUtils.put_int32(buff, current, i2, netorder);
            PackUtils.put_int32(buff, current + 4, i1, netorder);
        }
    }

    public static float get_float(byte[] buff, int current) {
        return PackUtils.get_float(buff, current, true);
    }

    public static float get_float(byte[] buff, int current, boolean netorder) {
        int val = PackUtils.get_int32(buff, current, netorder);
        return Float.intBitsToFloat(val);
    }

    public static void put_float(byte[] buff, int current, float value) {
        PackUtils.put_float(buff, current, value, true);
    }

    public static void put_float(byte[] buff, int current, float value, boolean netorder) {
        int val = Float.floatToIntBits(value);
        PackUtils.put_int32(buff, current, val, netorder);
    }

    public static double get_double(byte[] buff, int current) {
        return PackUtils.get_float(buff, current, true);
    }

    public static double get_double(byte[] buff, int current, boolean netorder) {
        long val = PackUtils.get_int64(buff, current, netorder);
        return Double.longBitsToDouble(val);
    }

    public static void put_double(byte[] buff, int current, double value) {
        PackUtils.put_double(buff, current, value, true);
    }

    public static void put_double(byte[] buff, int current, double value, boolean netorder) {
        long val = Double.doubleToLongBits(value);
        PackUtils.put_int64(buff, current, val, netorder);
    }

    public static String get_string(byte[] buff, int current, int length) {
        return PackUtils.get_string(buff, current, length, "gbk", ' ', true);
    }

    public static String get_string(byte[] buff, int current, int length, String encoding) {
        return PackUtils.get_string(buff, current, length, encoding, ' ', true);
    }

    public static String get_string(byte[] buff, int current, int length, String encoding, char fill) {
        return PackUtils.get_string(buff, current, length, encoding, fill, true);
    }

    public static String get_string(byte[] buff, int current, int length, String encoding, char fill, boolean left_align) {
        int start;
        int end;
        if ("EBCDIC".equalsIgnoreCase(encoding)) {
            encoding = "cp935";
        }
        String str = "";
        try {
            str = new String(buff, current, length, encoding);
        }
        catch (UnsupportedEncodingException e) {
            try {
                str = new String(buff, current, length, "ISO8859_1");
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
        }
        int len = str.length();
        if (left_align) {
            for (end = len - 1; end >= 0 && str.charAt(end) == fill; --end) {
            }
        } else {
            for (start = 0; start < len && str.charAt(start) == fill; ++start) {
            }
        }
        return str.substring(start, end + 1);
    }

    public static String get_string_untrim(byte[] buff, int current, int length, String encoding) {
        if ("EBCDIC".equalsIgnoreCase(encoding)) {
            encoding = "cp935";
        }
        String str = "";
        try {
            byte[] buffer = new byte[length];
            System.arraycopy(buff, current, buffer, 0, length);
            str = new String(buffer, encoding);
        }
        catch (UnsupportedEncodingException e) {
            try {
                str = new String(buff, current, length, "ISO8859_1");
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
        }
        return str;
    }

    public static void put_string(byte[] buff, int current, String value, int length) {
        PackUtils.put_string(buff, current, value, length, "gbk", ' ', true);
    }

    public static void put_string(byte[] buff, int current, String value, int length, String encoding) {
        PackUtils.put_string(buff, current, value, length, encoding, ' ', true);
    }

    public static void put_string(byte[] buff, int current, String value, int length, String encoding, char fill) {
        PackUtils.put_string(buff, current, value, length, encoding, fill, true);
    }

    public static void put_string(byte[] buff, int current, String value, int length, String encoding, char fill, boolean left_align) {
        int end;
        if (length <= 0) {
            return;
        }
        if (value == null) {
            value = "";
        }
        encoding = encoding == null ? "gbk" : encoding.toLowerCase();
        boolean ebcdic = false;
        boolean gbk = false;
        if ("ebcdic".equals(encoding)) {
            encoding = "cp935";
            ebcdic = true;
        } else if (encoding.startsWith("gb")) {
            gbk = true;
        }
        byte[] bv = null;
        try {
            bv = value.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            try {
                bv = value.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
        }
        int len = bv.length;
        if (len > length) {
            int diff = len - length;
            boolean in_gb_ebc = false;
            for (end = len - 1; diff > 0 && end >= 0; --end) {
                byte b = bv[end];
                if (b == 15) {
                    if (ebcdic) {
                        in_gb_ebc = true;
                        continue;
                    }
                    --diff;
                    continue;
                }
                if (b == 14) {
                    if (ebcdic) {
                        in_gb_ebc = false;
                        diff -= 2;
                        continue;
                    }
                    --diff;
                    continue;
                }
                if (in_gb_ebc) {
                    --end;
                    diff -= 2;
                    continue;
                }
                if ((b & 0x80) != 0 && gbk) {
                    --end;
                    diff -= 2;
                    continue;
                }
                --diff;
            }
            if (in_gb_ebc) {
                if (bv[end] == 14) {
                    --end;
                } else {
                    bv[++end] = 15;
                }
            }
        }
        if (++end < 0) {
            end = 0;
        }
        String fillstr = String.valueOf(new char[]{fill});
        byte fillbyte = (byte)fill;
        try {
            byte[] fillbv = fillstr.getBytes(encoding);
            fillbyte = fillbv[0];
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (left_align) {
            if (end > 0) {
                System.arraycopy(bv, 0, buff, current, end);
                current += end;
            }
            for (int i = 0; i < length - end; ++i) {
                buff[i + current] = fillbyte;
            }
        } else {
            for (int i = 0; i < length - end; ++i) {
                buff[i + current] = fillbyte;
            }
            if (end > 0) {
                System.arraycopy(bv, 0, buff, current + length - end, end);
                current += end;
            }
        }
    }

    public static double get_pack_decimal(byte[] buff, int current, int length, int scale) {
        int i;
        boolean negative;
        int total;
        int ch;
        byte[] dec = new byte[64];
        long intPart = 0L;
        double decPart = 0.0;
        if (length % 2 == 0) {
            ++length;
        }
        if ((ch = buff[current + (total = length / 2 + 1) - 1]) < 0) {
            ch += 256;
        }
        if (((ch & 0xF) == 15 || (ch & 0xF) == 12) && (ch & 0xF0) < 160) {
            negative = false;
            dec[length] = (byte)((ch & 0xF0) >> 4);
        } else if ((ch & 0xF) == 13 && (ch & 0xF0) < 160) {
            negative = true;
            dec[length] = (byte)((ch & 0xF0) >> 4);
        } else {
            ConvertException e = new ConvertException("InvalidPackDecimalChar");
            e.addScene("Offset", new Integer(current + total - 1));
            e.addScene("ByteValue", "0x" + Integer.toHexString(ch));
            throw e;
        }
        int j = 1;
        for (int i2 = current; i2 < current + total - 1; ++i2) {
            ch = buff[i2];
            if (ch < 0) {
                ch += 256;
            }
            if ((ch & 0xF) >= 10 || (ch & 0xF0) >= 160) {
                ConvertException e = new ConvertException("InvalidPackDecimalChar");
                e.addScene("Offset", new Integer(i2));
                e.addScene("ByteValue", "0x" + Integer.toHexString(ch));
                throw e;
            }
            dec[j++] = (byte)((ch & 0xF0) >> 4);
            dec[j++] = (byte)(ch & 0xF);
        }
        for (i = 1; i < length + 1 - scale; ++i) {
            intPart = intPart * 10L + (long)dec[i];
        }
        for (i = length; i >= length + 1 - scale; --i) {
            decPart = (decPart + (double)dec[i]) / 10.0;
        }
        double value = (double)intPart + decPart;
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static void put_pack_decimal(byte[] buff, int current, double value, int length, int scale) {
        int ch;
        long decPart;
        int i;
        byte[] dec = new byte[64];
        boolean negative = false;
        if (length % 2 == 0) {
            ++length;
        }
        if (value < 0.0) {
            negative = true;
            value = -value;
        }
        long intPart = (long)value;
        double remainder = value - (double)intPart;
        for (i = 0; i < scale; ++i) {
            remainder *= 10.0;
        }
        if ((remainder -= (double)(decPart = (long)remainder)) >= 0.5) {
            ++decPart;
        }
        for (i = length - scale - 1; i >= 0; --i) {
            ch = (int)(intPart % 10L);
            dec[i] = (byte)ch;
            intPart /= 10L;
        }
        for (i = length - 1; i >= length - scale; --i) {
            ch = (int)(decPart % 10L);
            dec[i] = (byte)ch;
            decPart /= 10L;
        }
        dec[length] = negative ? 13 : 15;
        int j = current;
        int i2 = 0;
        while (i2 < length) {
            byte c1 = dec[i2];
            byte c2 = dec[i2 + 1];
            buff[j] = (byte)(c1 << 4 | c2);
            i2 += 2;
            ++j;
        }
    }

    public static double get_zone_decimal(byte[] buff, int current, int length, int scale) {
        int ch;
        int i;
        long intPart = 0L;
        double floatPart = 0.0;
        boolean negative = false;
        for (i = current; i < current + length - scale; ++i) {
            ch = buff[i];
            if (ch < 0) {
                ch += 256;
            }
            if (ch == 64) {
                ch = 240;
            }
            if ((ch & 0xF) >= 10 || (ch & 0xF0) != 240) {
                if (i != current + length - 1 || (ch & 0xF) >= 10 || (ch & 0xF0) < 192) {
                    ConvertException e = new ConvertException("InvalidZoneDecimalChar");
                    e.addScene("Offset", new Integer(i));
                    e.addScene("ByteValue", "0x" + Integer.toHexString(ch));
                    throw e;
                }
                negative = (ch & 0xF0) != 192 && (ch & 0xF0) != 240;
            }
            intPart = intPart * 10L + (long)(ch &= 0xF);
        }
        if (scale > 0) {
            ch = buff[current + length - 1];
            if (ch < 0) {
                ch += 256;
            }
            if (ch == 64) {
                ch = 240;
            }
            if ((ch & 0xF) >= 10 || (ch & 0xF0) < 192) {
                ConvertException e = new ConvertException("InvalidZoneDecimalChar");
                e.addScene("Offset", new Integer(current + length - 1));
                e.addScene("ByteValue", "0x" + Integer.toHexString(ch));
                throw e;
            }
            negative = (ch & 0xF0) != 192 && (ch & 0xF0) != 240;
            floatPart = (double)(ch & 0xF) / 10.0;
            for (i = current + length - 2; i >= current + length - scale; --i) {
                ch = buff[i];
                if (ch < 0) {
                    ch += 256;
                }
                if (ch == 64) {
                    ch = 240;
                }
                if ((ch & 0xF) >= 10 || (ch & 0xF0) != 240) {
                    ConvertException e = new ConvertException("InvalidZoneDecimalChar");
                    e.addScene("Offset", new Integer(i));
                    e.addScene("ByteValue", "0x" + Integer.toHexString(ch));
                    throw e;
                }
                floatPart = (floatPart + (double)(ch &= 0xF)) / 10.0;
            }
        }
        double value = (double)intPart + floatPart;
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static void put_zone_decimal(byte[] buff, int current, double value, int length, int scale) {
        int ch;
        long decPart;
        int i;
        boolean negative = false;
        if (value < 0.0) {
            negative = true;
            value = -value;
        }
        long intPart = (long)value;
        double remainder = value - (double)intPart;
        for (i = 0; i < scale; ++i) {
            remainder *= 10.0;
        }
        if ((remainder -= (double)(decPart = (long)remainder)) >= 0.5) {
            ++decPart;
        }
        for (i = current + length - scale - 1; i >= current; --i) {
            ch = (int)(intPart % 10L);
            buff[i] = (byte)(ch + 240);
            intPart /= 10L;
        }
        for (i = current + length - 1; i >= current + length - scale; --i) {
            ch = (int)(decPart % 10L);
            buff[i] = (byte)(ch + 240);
            decPart /= 10L;
        }
        if (negative) {
            int n = current + length - 1;
            buff[n] = (byte)(buff[n] & 0xDF);
        }
    }
}

