/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.classloader;

import com.dc.util.classloader.Source;
import com.dc.util.zip.Handler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipSource
implements Source {
    private ZipFile zf;
    private ZipEntry ze;

    public ZipSource(ZipFile zipfile, ZipEntry zipentry) {
        this.zf = zipfile;
        this.ze = zipentry;
    }

    public InputStream getInputStream() throws IOException {
        return this.zf.getInputStream(this.ze);
    }

    public URL getURL() {
        try {
            String s = this.zf.getName().replace(File.separatorChar, '/');
            String s1 = s + '!' + '/' + this.ze.getName();
            return new URL("zip", "", s1);
        }
        catch (MalformedURLException mfe) {
            return null;
        }
    }

    public byte[] getBytes() {
        int len = (int)this.length();
        byte[] buff = new byte[len];
        try {
            InputStream input = this.getInputStream();
            for (int i = 0; i < len; i += input.read(buff, i, len - i)) {
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return buff;
    }

    public long lastModified() {
        return this.ze.getTime();
    }

    public long length() {
        return this.ze.getSize();
    }

    public String toString() {
        if (this.zf != null) {
            return this.zf.getName();
        }
        return "ZIP file " + this.getURL();
    }

    public ZipEntry getEntry() {
        return this.ze;
    }

    public ZipFile getFile() {
        return this.zf;
    }

    static {
        try {
            Handler.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

