/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.classloader;

import com.dc.util.classloader.ClassFinder;
import com.dc.util.classloader.ClassFinderUtil;
import com.dc.util.classloader.Source;
import com.dc.util.classloader.ZipSource;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipClassFinder
implements ClassFinder {
    private String path;
    private ZipFile file = null;
    private char sep = File.separatorChar;
    private ClassFinder mcf = null;

    public ZipClassFinder(String path) {
        this.path = path;
        try {
            this.file = new ZipFile(path);
            this.mcf = this.getManifestFinder();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Source getClassSource(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        String name = s.replace('.', this.sep) + ".class";
        return this.getSource(name);
    }

    public Source getSource(String s) {
        if (this.file == null) {
            return null;
        }
        if (s == null || s.equals("")) {
            return null;
        }
        String name = s.replace(this.sep, '/');
        ZipEntry ze = this.file.getEntry(name);
        if (ze != null) {
            return new ZipSource(this.file, ze);
        }
        if (this.mcf != null) {
            return this.mcf.getSource(s);
        }
        return null;
    }

    private ClassFinder getManifestFinder() {
        try {
            return ClassFinderUtil.getManifestFinder(this.file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "ZipClassFinder@" + this.hashCode() + "(" + this.path + ")";
    }
}

