/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.classloader;

import com.dc.util.StringUtils;
import com.dc.util.classloader.ClassFinder;
import com.dc.util.classloader.DirClassFinder;
import com.dc.util.classloader.Source;
import com.dc.util.classloader.ZipClassFinder;
import java.io.File;
import java.io.IOException;

public class PathClassFinder
implements ClassFinder {
    private String classpathStr;
    private String[] classpath;
    protected int[] flags;
    protected ClassFinder[] cfs;
    protected static final int NOT_EXIST = 0;
    protected static final int ZIP = 1;
    protected static final int DIR = 2;

    public PathClassFinder(String path) {
        this.classpathStr = path;
        this.classpath = StringUtils.splitCompletely(path, File.pathSeparator);
        int len = this.classpath.length;
        this.flags = new int[len];
        this.cfs = new ClassFinder[len];
        for (int i = 0; i < len; ++i) {
            File file = new File(this.classpath[i]);
            try {
                this.classpath[i] = file.getCanonicalPath();
                if (!file.exists()) {
                    this.flags[i] = 0;
                    continue;
                }
                if (file.isDirectory()) {
                    this.flags[i] = 2;
                    this.cfs[i] = new DirClassFinder(this.classpath[i]);
                    continue;
                }
                if (!file.isFile()) continue;
                this.flags[i] = 1;
                this.cfs[i] = new ZipClassFinder(this.classpath[i]);
                continue;
            }
            catch (IOException e) {
                this.flags[i] = 0;
            }
        }
    }

    public Source getClassSource(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        Source source = null;
        for (int i = 0; i < this.flags.length && (this.flags[i] == 0 || (source = this.cfs[i].getClassSource(s)) == null); ++i) {
        }
        return source;
    }

    public Source getSource(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        Source source = null;
        for (int i = 0; i < this.flags.length && (this.flags[i] == 0 || (source = this.cfs[i].getSource(s)) == null); ++i) {
        }
        return source;
    }

    public ClassFinder getManifestFinder() {
        return null;
    }

    public void close() {
        for (int i = 0; i < this.flags.length; ++i) {
            if (this.flags[i] == 0) continue;
            this.cfs[i].close();
        }
    }

    public String toString() {
        return "PathClassFinder@" + this.hashCode() + "(" + this.classpathStr + ")";
    }
}

