/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.classloader;

import com.dc.util.classloader.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileSource
implements Source {
    private static int GET_BYTES_RETRIES = 3;
    private File file;

    public FileSource(File file) {
        this.file = file;
    }

    public FileSource(String fileName) {
        this.file = new File(fileName);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public URL getURL() {
        if (this.file.exists()) {
            String s = this.file.getAbsolutePath().replace(File.separatorChar, '/');
            try {
                return this.file.toURL();
            }
            catch (MalformedURLException mfe) {
                return null;
            }
        }
        return null;
    }

    public byte[] getBytes() {
        byte[] is;
        for (int i = 0; i < GET_BYTES_RETRIES; ++i) {
            byte[] is2;
            try {
                is2 = this.getBytesInternal();
            }
            catch (IndexOutOfBoundsException ioe) {
                try {
                    Thread.sleep((int)(Math.random() * 3000.0));
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
            return is2;
        }
        try {
            is = this.getBytesInternal();
        }
        catch (IndexOutOfBoundsException ioe) {
            String string = "Could not read from " + this.file + " because some other process was writing it.";
            throw new RuntimeException(string);
        }
        return is;
    }

    private byte[] getBytesInternal() {
        byte[] is;
        try {
            int len = (int)this.length();
            byte[] buff = new byte[len];
            InputStream input = this.getInputStream();
            for (int i = 0; i < len; i += input.read(buff, i, len - i)) {
            }
            input.close();
            is = buff;
        }
        catch (IOException ioe) {
            return null;
        }
        return is;
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public long length() {
        return this.file.length();
    }

    public String toString() {
        if (this.file != null) {
            return this.file.toString();
        }
        return "Unknown FileSource";
    }

    public File getFile() {
        return this.file;
    }
}

