/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.classloader;

import com.dc.util.classloader.ClassFinder;
import com.dc.util.classloader.ClassFinderUtil;
import com.dc.util.classloader.FileSource;
import com.dc.util.classloader.Source;
import java.io.File;
import java.io.IOException;

public class DirClassFinder
implements ClassFinder {
    private String path;
    private char sep = File.separatorChar;
    private ClassFinder mcf = null;

    public DirClassFinder(String path) {
        this.path = path;
        if (path.charAt(path.length() - 1) != this.sep) {
            this.path = this.path + this.sep;
        }
        this.mcf = this.getManifestFinder();
    }

    public Source getClassSource(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        String name = s.replace('.', this.sep) + ".class";
        return this.getSource(name);
    }

    public Source getSource(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        String name = s.replace('/', this.sep);
        name = this.path + name;
        File file = new File(name);
        if (file.exists()) {
            return new FileSource(file);
        }
        if (this.mcf != null) {
            return this.mcf.getSource(s);
        }
        return null;
    }

    private ClassFinder getManifestFinder() {
        try {
            return ClassFinderUtil.getManifestFinder(new File(this.path));
        }
        catch (IOException e) {
            return null;
        }
    }

    public void close() {
    }

    public String toString() {
        return "DirClassFinder@" + this.hashCode() + "(" + this.path + ")";
    }
}

