/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.classloader;

import com.dc.util.StringUtils;
import com.dc.util.classloader.ClassFinder;
import com.dc.util.classloader.PathClassFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFinderUtil {
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFinder getManifestFinder(File file) throws IOException {
        String path;
        File manfile = new File(file, MANIFEST_ENTRY);
        if (!manfile.exists()) {
            return null;
        }
        Attributes attr = null;
        FileInputStream input = new FileInputStream(manfile);
        try {
            Manifest manifest = new Manifest(input);
            attr = manifest.getMainAttributes();
        }
        finally {
            input.close();
        }
        if (attr != null && (path = (String)attr.get(Attributes.Name.CLASS_PATH)) != null) {
            path = ClassFinderUtil.convertManifestClassPath(file.getPath(), path);
            return new PathClassFinder(path);
        }
        return null;
    }

    public static ClassFinder getManifestFinder(ZipFile zipfile) throws IOException {
        String path;
        Attributes attr;
        ZipEntry ze = zipfile.getEntry(MANIFEST_ENTRY);
        Manifest manifest = null;
        if (ze != null) {
            manifest = new Manifest(zipfile.getInputStream(ze));
        }
        if (manifest != null && (attr = manifest.getMainAttributes()) != null && (path = (String)attr.get(Attributes.Name.CLASS_PATH)) != null) {
            path = ClassFinderUtil.convertManifestClassPath(zipfile.getName(), path);
            return new PathClassFinder(path);
        }
        return null;
    }

    private static String convertManifestClassPath(String path, String classpathStr) {
        StringBuffer buff = new StringBuffer();
        int pos = path.lastIndexOf(File.separatorChar);
        String dirname = "";
        if (pos >= 0) {
            dirname = path.substring(0, pos + 1);
        }
        String[] classpath = StringUtils.splitCompletely(classpathStr, " ");
        for (int i = 0; i < classpath.length; ++i) {
            buff.append(dirname);
            classpath[i] = classpath[i].replace('/', File.separatorChar);
            buff.append(classpath[i]);
            if (i >= classpath.length - 1) continue;
            buff.append(File.pathSeparatorChar);
        }
        return buff.toString();
    }
}

