/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.classloader;

import com.dc.util.classloader.ClassFinder;
import com.dc.util.classloader.Source;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangeAwareClassLoader
extends ClassLoader {
    private static Log logger = LogFactory.getLog((Class)ChangeAwareClassLoader.class);
    private Map modTimes = new Hashtable();
    private Map cachedClasses = new Hashtable();
    private Map cachedResources = new Hashtable();
    private boolean upTodate = true;
    private long lastChecked;
    private ClassFinder finder;
    private boolean delegate = false;

    public ChangeAwareClassLoader(ClassFinder finder) {
        this(finder, Thread.currentThread().getContextClassLoader());
    }

    public ChangeAwareClassLoader(ClassFinder finder, ClassLoader parent) {
        super(parent);
        this.finder = finder;
        this.lastChecked = System.currentTimeMillis();
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized Class loadClass(String s, boolean resolve) throws ClassNotFoundException {
        class1 = (Class)this.cachedClasses.get(s);
        if (class1 == null) {
            try {
                if (this.delegate) {
                    try {
                        class1 = this.getParent().loadClass(s);
                        if (class1 == null) ** GOTO lbl30
                        this.cachedClasses.put(s, class1);
                    }
                    catch (ClassNotFoundException e) {
                        class1 = this.findClass(s);
                        this.cachedClasses.put(s, class1);
                    }
                }
                class1 = this.findClass(s);
                this.cachedClasses.put(s, class1);
            }
            catch (NullPointerException e) {
                if (ChangeAwareClassLoader.logger.isErrorEnabled()) {
                    ChangeAwareClassLoader.logger.error((Object)("ClassName[" + s + "],ClassObject[" + class1 + "]"), (Throwable)e);
                }
                throw e;
            }
            catch (ClassNotFoundException e) {
                if (ChangeAwareClassLoader.logger.isInfoEnabled()) {
                    ChangeAwareClassLoader.logger.info((Object)("Load class[" + s + "] from super classloader!"));
                }
                return super.loadClass(s, resolve);
            }
        } else if (ChangeAwareClassLoader.logger.isInfoEnabled()) {
            ChangeAwareClassLoader.logger.info((Object)("Load class[" + s + "] from cache!"));
        }
lbl30:
        // 7 sources

        if (resolve) {
            this.resolveClass(class1);
        }
        return class1;
    }

    protected synchronized Class findClass(String s) throws ClassNotFoundException {
        Source source = this.finder.getClassSource(s);
        if (source != null) {
            Class class1 = this.reallyLoadClass(source, s);
            long l = source.lastModified();
            this.modTimes.put(this.getFileName(s), new Long(l));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Load class[" + s + "] from [" + this.finder + "]!"));
            }
            return class1;
        }
        throw new ClassNotFoundException(s);
    }

    private synchronized Class reallyLoadClass(Source source, String className) {
        byte[] classData = source.getBytes();
        try {
            Class<?> newClass = this.defineClass(className, classData, 0, classData.length);
            return newClass;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public URL getResource(String s) {
        URL url = this.findResource(s);
        if (url == null) {
            return super.getResource(s);
        }
        return url;
    }

    protected synchronized URL findResource(String s) {
        URL url = (URL)this.cachedResources.get(s);
        if (url != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Find resource[" + s + "] from cache!"));
            }
            return url;
        }
        Source source = this.finder.getSource(s);
        if (source != null) {
            url = source.getURL();
            if (url == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)(s + " url cannot find in " + source));
                }
                throw new NullPointerException(s + " url cannot find in " + source);
            }
            this.cachedResources.put(s, url);
            long l = source.lastModified();
            this.modTimes.put(s, new Long(l));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Find resource[" + s + "] from [" + this.finder + "]!"));
            }
            return url;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Cannot find resource[" + s + "]!"));
        }
        return null;
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    public void resetLastChecked() {
        this.lastChecked = System.currentTimeMillis();
    }

    public boolean upToDate() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Check uptodate for " + this.toString()));
        }
        if (!this.upTodate) {
            return false;
        }
        this.resetLastChecked();
        Iterator iterator = this.modTimes.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            long l = (Long)this.modTimes.get(name);
            Source source = this.finder.getSource(name);
            if (source == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Source[" + name + "] not exist!"));
                }
                this.upTodate = false;
                return false;
            }
            long l1 = source.lastModified();
            if (l1 != l) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Source[" + name + "] modified!"));
                }
                this.upTodate = false;
                return false;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Source[" + name + "] uptodate!"));
        }
        return true;
    }

    private String getFileName(String className) {
        String fileName = className.replace('.', '/') + ".class";
        return fileName;
    }

    public String toString() {
        return "ChangeAwareClassLoader@" + this.hashCode() + "(" + this.finder + ")";
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }
}

