/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.bean;

import com.dc.util.bean.ClassAdaptor;
import com.dc.util.bean.PropertyUtilException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyUtils {
    private static final Map _classAdaptors = new HashMap();

    private PropertyUtils() {
    }

    public static void write(Object target, String propertyName, Object value) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        a.write(target, propertyName, value);
    }

    public static boolean isWritable(Object target, String propertyName) {
        return PropertyUtils.getAdaptor(target).isWritable(propertyName);
    }

    public static boolean isReadable(Object target, String propertyName) {
        return PropertyUtils.getAdaptor(target).isReadable(propertyName);
    }

    public static Object read(Object target, String propertyName) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        return a.read(target, propertyName);
    }

    public static Class getPropertyType(Object target, String propertyName) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        return a.getPropertyType(target, propertyName);
    }

    public static List getReadableProperties(Object target) {
        return PropertyUtils.getAdaptor(target).getReadableProperties();
    }

    public static List getWriteableProperties(Object target) {
        return PropertyUtils.getAdaptor(target).getWriteableProperties();
    }

    private static synchronized ClassAdaptor getAdaptor(Object target) {
        Class<?> targetClass = target.getClass();
        ClassAdaptor result = (ClassAdaptor)_classAdaptors.get(targetClass);
        if (result == null) {
            result = PropertyUtils.buildClassAdaptor(target, targetClass);
            _classAdaptors.put(targetClass, result);
        }
        return result;
    }

    private static ClassAdaptor buildClassAdaptor(Object target, Class targetClass) {
        try {
            BeanInfo info = Introspector.getBeanInfo(targetClass);
            return new ClassAdaptor(info.getPropertyDescriptors());
        }
        catch (Exception ex) {
            PropertyUtilException e = new PropertyUtilException("unable-to-inspect");
            e.addScene("Target", target);
            throw e;
        }
    }
}

