/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.bean;

import com.dc.util.bean.PropertyUtilException;
import java.lang.reflect.Method;

class PropertyAdaptor {
    private String _propertyName;
    private Class _propertyType;
    private Method _readMethod;
    private Method _writeMethod;

    PropertyAdaptor(String propertyName, Class propertyType, Method readMethod, Method writeMethod) {
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._readMethod = readMethod;
        this._writeMethod = writeMethod;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Class getPropertyType() {
        return this._propertyType;
    }

    public void write(Object target, Object value) {
        if (this._writeMethod == null) {
            PropertyUtilException e = new PropertyUtilException("no-property-writer");
            e.addScene("Property", this._propertyName);
            e.addScene("Target", target);
            throw e;
        }
        try {
            this._writeMethod.invoke(target, value);
        }
        catch (Exception ex) {
            PropertyUtilException e = new PropertyUtilException("property-write-fail", ex);
            e.addScene("Property", this._propertyName);
            e.addScene("Target", target);
            throw e;
        }
    }

    public boolean isWritable() {
        return this._writeMethod != null;
    }

    public Object read(Object target) {
        if (this._readMethod == null) {
            PropertyUtilException e = new PropertyUtilException("no-property-reader");
            e.addScene("Property", this._propertyName);
            e.addScene("Target", target);
            throw e;
        }
        try {
            return this._readMethod.invoke(target, null);
        }
        catch (Exception ex) {
            PropertyUtilException e = new PropertyUtilException("property-reader-fail", ex);
            e.addScene("Property", this._propertyName);
            e.addScene("Target", target);
            throw e;
        }
    }

    public boolean isReadable() {
        return this._readMethod != null;
    }
}

