/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.bean;

import com.dc.util.bean.PropertyAdaptor;
import com.dc.util.bean.PropertyUtilException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ClassAdaptor {
    private final Map _propertyAdaptorMap = new HashMap();

    public ClassAdaptor(PropertyDescriptor[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor d = properties[i];
            String name = d.getName();
            this._propertyAdaptorMap.put(name, new PropertyAdaptor(name, d.getPropertyType(), d.getReadMethod(), d.getWriteMethod()));
        }
    }

    public void write(Object target, String propertyName, Object value) {
        PropertyAdaptor a = this.getAdaptor(target, propertyName);
        a.write(target, value);
    }

    public Object read(Object target, String propertyName) {
        PropertyAdaptor a = this.getAdaptor(target, propertyName);
        return a.read(target);
    }

    public Class getPropertyType(Object target, String propertyName) {
        PropertyAdaptor a = this.getAdaptor(target, propertyName);
        return a.getPropertyType();
    }

    public boolean isReadable(String propertyName) {
        PropertyAdaptor result = (PropertyAdaptor)this._propertyAdaptorMap.get(propertyName);
        return result != null && result.isReadable();
    }

    public boolean isWritable(String propertyName) {
        PropertyAdaptor result = (PropertyAdaptor)this._propertyAdaptorMap.get(propertyName);
        return result != null && result.isWritable();
    }

    private PropertyAdaptor getAdaptor(Object target, String propertyName) {
        PropertyAdaptor result = (PropertyAdaptor)this._propertyAdaptorMap.get(propertyName);
        if (result == null) {
            PropertyUtilException e = new PropertyUtilException("no-such-property");
            e.addScene("Property", propertyName);
            e.addScene("Target", target);
            throw e;
        }
        return result;
    }

    public List getReadableProperties() {
        ArrayList<String> result = new ArrayList<String>(this._propertyAdaptorMap.size());
        Iterator i = this._propertyAdaptorMap.values().iterator();
        while (i.hasNext()) {
            PropertyAdaptor a = (PropertyAdaptor)i.next();
            if (!a.isReadable()) continue;
            result.add(a.getPropertyName());
        }
        return result;
    }

    public List getWriteableProperties() {
        ArrayList<String> result = new ArrayList<String>(this._propertyAdaptorMap.size());
        Iterator i = this._propertyAdaptorMap.values().iterator();
        while (i.hasNext()) {
            PropertyAdaptor a = (PropertyAdaptor)i.next();
            if (!a.isWritable()) continue;
            result.add(a.getPropertyName());
        }
        return result;
    }
}

