/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util.bean;

import com.dc.exception.BaseException;
import com.dc.util.NumberUtils;
import com.dc.util.bean.Attribute;
import com.dc.util.bean.AttributeType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class BeanUtils {
    private BeanUtils() {
    }

    public static Class classType(AttributeType type) {
        if (type == AttributeType.BYTE_TYPE) {
            return Byte.TYPE;
        }
        if (type == AttributeType.SHORT_TYPE) {
            return Byte.TYPE;
        }
        if (type == AttributeType.INT_TYPE) {
            return Integer.TYPE;
        }
        if (type == AttributeType.LONG_TYPE) {
            return Long.TYPE;
        }
        if (type == AttributeType.CHAR_TYPE) {
            return Character.TYPE;
        }
        if (type == AttributeType.FLOAT_TYPE) {
            return Float.TYPE;
        }
        if (type == AttributeType.DOUBLE_TYPE) {
            return Double.TYPE;
        }
        if (type == AttributeType.STRING_TYPE) {
            return String.class;
        }
        if (type == AttributeType.OBJECT_TYPE) {
            return Object.class;
        }
        return null;
    }

    public static Object argObject(Attribute attr) {
        AttributeType type = attr.getType();
        if (type == AttributeType.BYTE_TYPE) {
            return new Byte((byte)NumberUtils.intValue(attr.getValue()));
        }
        if (type == AttributeType.SHORT_TYPE) {
            return new Short((short)NumberUtils.intValue(attr.getValue()));
        }
        if (type == AttributeType.INT_TYPE) {
            return new Integer(NumberUtils.intValue(attr.getValue()));
        }
        if (type == AttributeType.CHAR_TYPE) {
            return new Character(attr.getValue().charAt(0));
        }
        if (type == AttributeType.LONG_TYPE) {
            return new Long(NumberUtils.longValue(attr.getValue()));
        }
        if (type == AttributeType.FLOAT_TYPE) {
            return new Float((float)NumberUtils.doubleValue(attr.getValue()));
        }
        if (type == AttributeType.DOUBLE_TYPE) {
            return new Double(NumberUtils.doubleValue(attr.getValue()));
        }
        if (type == AttributeType.STRING_TYPE) {
            return attr.getValue();
        }
        if (type == AttributeType.OBJECT_TYPE) {
            return attr.getValue();
        }
        return null;
    }

    public static Method getMethod(Object bean, String name, Class[] para) {
        try {
            Method method = bean.getClass().getMethod(name, para);
            if (!Modifier.isPublic(method.getModifiers())) {
                BaseException e = new BaseException("Method not public exception");
                e.addScene("MethodName", name);
                for (int i = 0; i < para.length; ++i) {
                    e.addScene("Parameter" + i, para[i]);
                }
                throw e;
            }
            return method;
        }
        catch (Exception e1) {
            BaseException e = new BaseException("No such method exception", e1);
            e.addScene("MethodName", name);
            for (int i = 0; i < para.length; ++i) {
                e.addScene("Parameter" + i, para[i]);
            }
            throw e;
        }
    }

    public static void setBeanAttribute(Object bean, Attribute attr) {
        Class[] para = new Class[]{BeanUtils.classType(attr.getType())};
        String name = attr.getName();
        name = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        Method method = BeanUtils.getMethod(bean, name, para);
        Object[] args = new Object[]{BeanUtils.argObject(attr)};
        try {
            method.invoke(bean, args);
        }
        catch (Exception e1) {
            int i;
            BaseException e = new BaseException("Invoke method exception", e1);
            e.addScene("MethodName", name);
            for (i = 0; i < para.length; ++i) {
                e.addScene("Parameter" + i, para[i]);
            }
            for (i = 0; i < para.length; ++i) {
                e.addScene("Argument" + i, args[i]);
            }
            throw e;
        }
    }
}

