/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util;

import java.io.Serializable;

public final class UnsyncStringBuffer
implements Serializable {
    private char[] value;
    private int count;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;

    public UnsyncStringBuffer() {
        this(16);
    }

    public UnsyncStringBuffer(int i) {
        this.value = new char[i];
        this.shared = false;
    }

    public UnsyncStringBuffer(String s) {
        this(s.length() + 16);
        this.append(s);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copyWhenShared() {
        if (this.shared) {
            char[] ac = new char[this.value.length];
            System.arraycopy(this.value, 0, ac, 0, this.count);
            this.value = ac;
            this.shared = false;
        }
    }

    public void ensureCapacity(int i) {
        int j = this.value.length;
        if (i > j) {
            int k = (j + 1) * 2;
            if (i > k) {
                k = i;
            }
            char[] ac = new char[k];
            System.arraycopy(this.value, 0, ac, 0, this.count);
            this.value = ac;
            this.shared = false;
        }
    }

    public void setLength(int i) {
        if (i < 0) {
            throw new StringIndexOutOfBoundsException(i);
        }
        this.ensureCapacity(i);
        if (this.count < i) {
            this.copyWhenShared();
            while (this.count < i) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        }
        this.count = i;
    }

    public char charAt(int i) {
        if (i < 0 || i >= this.count) {
            throw new StringIndexOutOfBoundsException(i);
        }
        return this.value[i];
    }

    public void getChars(int i, int j, char[] ac, int k) {
        if (i < 0 || i >= this.count) {
            throw new StringIndexOutOfBoundsException(i);
        }
        if (j < 0 || j > this.count) {
            throw new StringIndexOutOfBoundsException(j);
        }
        if (i < j) {
            System.arraycopy(this.value, i, ac, k, j - i);
        }
    }

    public void setCharAt(int i, char c) {
        if (i < 0 || i >= this.count) {
            throw new StringIndexOutOfBoundsException(i);
        }
        this.copyWhenShared();
        this.value[i] = c;
    }

    public UnsyncStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public UnsyncStringBuffer append(String s) {
        if (s == null) {
            s = String.valueOf(s);
        }
        int i = s.length();
        this.ensureCapacity(this.count + i);
        this.copyWhenShared();
        s.getChars(0, i, this.value, this.count);
        this.count += i;
        return this;
    }

    public UnsyncStringBuffer append(char[] ac) {
        int i = ac.length;
        this.ensureCapacity(this.count + i);
        this.copyWhenShared();
        System.arraycopy(ac, 0, this.value, this.count, i);
        this.count += i;
        return this;
    }

    public UnsyncStringBuffer append(char[] ac, int i, int j) {
        this.ensureCapacity(this.count + j);
        this.copyWhenShared();
        System.arraycopy(ac, i, this.value, this.count, j);
        this.count += j;
        return this;
    }

    public UnsyncStringBuffer append(boolean flag) {
        return this.append(String.valueOf(flag));
    }

    public UnsyncStringBuffer append(char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        this.value[this.count++] = c;
        return this;
    }

    public UnsyncStringBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public UnsyncStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public UnsyncStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public UnsyncStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public UnsyncStringBuffer insert(int i, Object obj) {
        return this.insert(i, String.valueOf(obj));
    }

    public UnsyncStringBuffer insert(int i, String s) {
        if (i < 0 || i > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int j = s.length();
        this.ensureCapacity(this.count + j);
        this.copyWhenShared();
        System.arraycopy(this.value, i, this.value, i + j, this.count - i);
        s.getChars(0, j, this.value, i);
        this.count += j;
        return this;
    }

    public UnsyncStringBuffer insert(int i, char[] ac) {
        if (i < 0 || i > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int j = ac.length;
        this.ensureCapacity(this.count + j);
        this.copyWhenShared();
        System.arraycopy(this.value, i, this.value, i + j, this.count - i);
        System.arraycopy(ac, 0, this.value, i, j);
        this.count += j;
        return this;
    }

    public UnsyncStringBuffer insert(int i, boolean flag) {
        return this.insert(i, String.valueOf(flag));
    }

    public UnsyncStringBuffer insert(int i, char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        System.arraycopy(this.value, i, this.value, i + 1, this.count - i);
        this.value[i] = c;
        ++this.count;
        return this;
    }

    public UnsyncStringBuffer insert(int i, int j) {
        return this.insert(i, String.valueOf(j));
    }

    public UnsyncStringBuffer insert(int i, long l) {
        return this.insert(i, String.valueOf(l));
    }

    public UnsyncStringBuffer insert(int i, float f) {
        return this.insert(i, String.valueOf(f));
    }

    public UnsyncStringBuffer insert(int i, double d) {
        return this.insert(i, String.valueOf(d));
    }

    public UnsyncStringBuffer reverse() {
        this.copyWhenShared();
        int i = this.count - 1;
        for (int j = i - 1 >> 1; j >= 0; --j) {
            char c = this.value[j];
            this.value[j] = this.value[i - j];
            this.value[i - j] = c;
        }
        return this;
    }

    public String toString() {
        this.shared = true;
        return new String(this.value, 0, this.count);
    }
}

