/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util;

import com.dc.util.UnsyncStringBuffer;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public final class StringUtils {
    private static final int DEFAULT_LIMIT = 3072;
    private static String keystr = "{:}[],|;=%\\";
    private static char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StringUtils() {
    }

    public static String[] split(String s, String delims) {
        ArrayList<String> list = new ArrayList<String>();
        int lastpos = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (delims.indexOf(c) < 0) continue;
            String ss = s.substring(lastpos, i);
            list.add(ss.trim());
            lastpos = i + 1;
        }
        if (lastpos >= length) {
            list.add("");
        } else {
            String ss = s.substring(lastpos, length);
            list.add(ss.trim());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String s, char c) {
        return StringUtils.split(s, String.valueOf(c));
    }

    public static String[] splitCompletely(String s, String s1, boolean flag) {
        return StringUtils.splitCompletely(new StringTokenizer(s, s1, flag));
    }

    public static String[] splitCompletely(String s, String s1) {
        return StringUtils.splitCompletely(new StringTokenizer(s, s1));
    }

    public static String[] splitCompletely(String s) {
        return StringUtils.splitCompletely(new StringTokenizer(s));
    }

    private static String[] splitCompletely(StringTokenizer stringtokenizer) {
        int i = stringtokenizer.countTokens();
        String[] as = new String[i];
        for (int j = 0; j < i; ++j) {
            as[j] = stringtokenizer.nextToken();
        }
        return as;
    }

    public static String[] splitPartially(String s, String s1, int i) {
        String[] as;
        StringTokenizer stringtokenizer = new StringTokenizer(s, s1);
        int j = stringtokenizer.countTokens();
        if (i == 0 || i >= j) {
            as = new String[j];
            for (int k = 0; k < j; ++k) {
                as[k] = stringtokenizer.nextToken();
            }
        } else {
            as = new String[i];
            for (int l = 0; l < i - 1; ++l) {
                as[l] = stringtokenizer.nextToken();
            }
            as[l] = stringtokenizer.nextToken() + stringtokenizer.nextToken("");
        }
        return as;
    }

    public static String join(String[] as, String s) {
        if (as == null) {
            as = new String[]{};
        }
        return StringUtils.join(as, s, 0, as.length);
    }

    public static String join(String[] as, String s, int i, int j) {
        if (as == null) {
            as = new String[]{};
        }
        UnsyncStringBuffer unsyncstringbuffer = new UnsyncStringBuffer();
        for (int k = i; k < j; ++k) {
            unsyncstringbuffer.append(as[k]);
            if (k >= j - 1) continue;
            unsyncstringbuffer.append(s);
        }
        return unsyncstringbuffer.toString();
    }

    public static int nthIndexOf(String s, int i) {
        int j = 0;
        for (int k = 0; k < i && (j = s.indexOf(":", j + 1)) != -1; ++k) {
        }
        return j;
    }

    public static String upto(String s, char c) {
        int i = s.indexOf(c);
        if (i != -1) {
            return s.substring(0, i);
        }
        return s;
    }

    public static String ucfirst(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String escapeString(String s) {
        char[] ac = s.toCharArray();
        int i = ac.length;
        UnsyncStringBuffer unsyncstringbuffer = new UnsyncStringBuffer(i);
        block10: for (int j = 0; j < i; ++j) {
            char c = ac[j];
            switch (c) {
                case '\b': {
                    unsyncstringbuffer.append("\\b");
                    continue block10;
                }
                case '\t': {
                    unsyncstringbuffer.append("\\t");
                    continue block10;
                }
                case '\n': {
                    unsyncstringbuffer.append("\\n");
                    continue block10;
                }
                case '\f': {
                    unsyncstringbuffer.append("\\f");
                    continue block10;
                }
                case '\r': {
                    unsyncstringbuffer.append("\\r");
                    continue block10;
                }
                case '\"': {
                    unsyncstringbuffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    unsyncstringbuffer.append("\\'");
                    continue block10;
                }
                case '\\': {
                    unsyncstringbuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    unsyncstringbuffer.append(c);
                }
            }
        }
        return unsyncstringbuffer.toString();
    }

    public static String toLowerCase(String s) {
        int i = s.length();
        int j = -1;
        for (int k = i - 1; k >= 0; --k) {
            char c = s.charAt(k);
            if (Character.toLowerCase(c) == c) continue;
            j = k;
            break;
        }
        if (j == -1) {
            return s;
        }
        char[] ac = new char[i];
        s.getChars(0, i, ac, 0);
        for (int l = j; l >= 0; --l) {
            ac[l] = Character.toLowerCase(ac[l]);
        }
        return new String(ac);
    }

    public static String bracket(String s) {
        if (s == null) {
            return "[!null!]";
        }
        return "[" + s + "]";
    }

    public static String valueOf(int i) {
        boolean flag;
        char[] ac = new char[11];
        int j = ac.length;
        boolean bl = flag = i < 0;
        if (!flag) {
            i = -i;
        }
        while (i <= -10) {
            ac[--j] = Character.forDigit(-(i % 10), 10);
            i /= 10;
        }
        ac[--j] = Character.forDigit(-i, 10);
        if (flag) {
            ac[--j] = 45;
        }
        return new String(ac, j, ac.length - j);
    }

    public static String valueOf(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    public static String valueOf(char[] ac) {
        return new String(ac);
    }

    public static String valueOf(boolean flag) {
        return flag ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] ac = new char[]{c};
        return new String(ac);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String numStr4Java(String s, char c, char c1) {
        if (s == null) {
            return null;
        }
        UnsyncStringBuffer unsyncstringbuffer = new UnsyncStringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            if (c2 == c) continue;
            if (c2 == c1) {
                unsyncstringbuffer.append('.');
                continue;
            }
            unsyncstringbuffer.append(c2);
        }
        return unsyncstringbuffer.toString();
    }

    public static String takeCommasFromNumStr(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(44) == -1) {
            return s;
        }
        return StringUtils.numStr4Java(s, ',', '.');
    }

    public static String padStringWidth(String s, int i) {
        UnsyncStringBuffer unsyncstringbuffer;
        if (s != null) {
            int j;
            unsyncstringbuffer = new UnsyncStringBuffer(s);
            unsyncstringbuffer.setLength(i);
            for (int l = j = s.length(); l < i; ++l) {
                unsyncstringbuffer.setCharAt(l, ' ');
            }
        } else {
            unsyncstringbuffer = new UnsyncStringBuffer(i);
            for (int k = 0; k < i; ++k) {
                unsyncstringbuffer.setCharAt(k, ' ');
            }
        }
        return unsyncstringbuffer.toString();
    }

    public static String padStringWidth(int i, int j) {
        return StringUtils.padStringWidth(String.valueOf(i), j);
    }

    public static String padStringWidth(float f, int i) {
        return StringUtils.padStringWidth(String.valueOf(f), i);
    }

    public static String padStringWidth(long l, int i) {
        return StringUtils.padStringWidth(String.valueOf(l), i);
    }

    public static String padStringWidth(double d, int i) {
        return StringUtils.padStringWidth(String.valueOf(d), i);
    }

    public static String padNumberWidth(long l, int i) {
        UnsyncStringBuffer unsyncstringbuffer = new UnsyncStringBuffer(i);
        for (int j = i - 1; j >= 0; --j) {
            long l1 = (long)Math.pow(10.0, j);
            long l2 = l / l1;
            unsyncstringbuffer.append(l2);
            l -= l2 * l1;
        }
        return unsyncstringbuffer.toString();
    }

    public static String replaceGlobal(String s, String s1, String s2) {
        int j;
        UnsyncStringBuffer unsyncstringbuffer = new UnsyncStringBuffer();
        int i = 0;
        while ((j = s.indexOf(s1, i)) >= 0) {
            unsyncstringbuffer.append(s.substring(i, j));
            unsyncstringbuffer.append(s2);
            i = j + s1.length();
        }
        unsyncstringbuffer.append(s.substring(i));
        return unsyncstringbuffer.toString();
    }

    public static boolean isEmptyString(String s) {
        return s == null || s.length() == 0 || StringUtils.isWhitespace(s);
    }

    public static boolean isWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String mangle(String s) {
        char[] ac = s.toCharArray();
        long l = 0L;
        for (int i = 0; i < ac.length; ++i) {
            l = 129L * l + (long)ac[i];
        }
        return Long.toString(l, 36);
    }

    public static String formatLines(String s, int i, Locale locale) {
        StringBuffer stringbuffer = new StringBuffer();
        BreakIterator breakiterator = BreakIterator.getLineInstance(locale);
        breakiterator.setText(s);
        int j = breakiterator.first();
        int k = breakiterator.next();
        int l = 0;
        while (k != -1) {
            String s1 = s.substring(j, k);
            if ((l += s1.length()) >= i) {
                stringbuffer.append("\n");
                l = s1.length();
            }
            stringbuffer.append(s1);
            if (s1.indexOf("\n") >= 0) {
                l = 0;
            }
            j = k;
            k = breakiterator.next();
        }
        return new String(stringbuffer);
    }

    private static boolean inKeycharList(char c) {
        return keystr.indexOf(c) >= 0;
    }

    private static int hexchar2value(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return c - 48;
    }

    public static String toHex(byte b) {
        return StringUtils.char2hex((char)b);
    }

    public static byte fromHex(String s) {
        return StringUtils.fromHex(s, 0);
    }

    public static byte fromHex(String s, int pos) {
        return (byte)StringUtils.hex2char(s, pos);
    }

    private static String char2hex(char c) {
        StringBuffer sbuff = new StringBuffer(2);
        int value = c & 0xFF;
        sbuff.append(hexchar[value >> 4]);
        sbuff.append(hexchar[value & 0xF]);
        return sbuff.toString();
    }

    private static char hex2char(String s) {
        return StringUtils.hex2char(s, 0);
    }

    private static char hex2char(String s, int pos) {
        return (char)((StringUtils.hexchar2value(s.charAt(pos)) << 4) + StringUtils.hexchar2value(s.charAt(pos + 1)));
    }

    private static boolean ishexchar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String escape(String s) {
        StringBuffer sbuff = new StringBuffer(s.length() + 10);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (StringUtils.inKeycharList(c)) {
                sbuff.append("%").append(StringUtils.char2hex(c));
                continue;
            }
            if (c == '\r') {
                sbuff.append("\\r");
                continue;
            }
            if (c == '\n') {
                sbuff.append("\\n");
                continue;
            }
            if (c == '\t') {
                sbuff.append("\\t");
                continue;
            }
            sbuff.append(c);
        }
        return sbuff.toString();
    }

    public static String unescape(String s) {
        StringBuffer sbuff = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (StringUtils.ishexchar(s.charAt(i + 1)) && StringUtils.ishexchar(s.charAt(i + 2))) {
                    sbuff.append(StringUtils.hex2char(s, i + 1));
                    i += 2;
                    continue;
                }
                sbuff.append(c);
                continue;
            }
            if (c == '\\') {
                if ((c = s.charAt(++i)) == 'r') {
                    sbuff.append('\r');
                    continue;
                }
                if (c == 'n') {
                    sbuff.append('\n');
                    continue;
                }
                if (c == 't') {
                    sbuff.append('\t');
                    continue;
                }
                sbuff.append('\\').append(c);
                continue;
            }
            sbuff.append(c);
        }
        return sbuff.toString();
    }

    private static int pairIndex(String s, int start, char left, char right) {
        int level = 0;
        for (int i = start + 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == left) {
                ++level;
                continue;
            }
            if (c != right) continue;
            if (level == 0) {
                return i;
            }
            --level;
        }
        return -1;
    }

    private static String[] mysplit(String s, String token) {
        int pos;
        ArrayList<String> list = new ArrayList<String>();
        int count = s.length();
        int lastpos = 0;
        for (pos = 0; pos < count; ++pos) {
            char c = s.charAt(pos);
            if (c == '[') {
                int index = StringUtils.pairIndex(s, pos, '[', ']');
                if (index > 0) {
                    pos = index;
                    continue;
                }
                throw new RuntimeException("\u4e0d\u5339\u914d\u7684[\u5bf9At" + pos + ":" + StringUtils.bracket(s));
            }
            if (c == '{') {
                int index = StringUtils.pairIndex(s, pos, '{', '}');
                if (index > 0) {
                    pos = index;
                    continue;
                }
                throw new RuntimeException("\u4e0d\u5339\u914d\u7684{\u5bf9At" + pos + ":" + StringUtils.bracket(s));
            }
            if (token.indexOf(c) < 0) continue;
            String ss = s.substring(lastpos, pos);
            list.add(ss.trim());
            lastpos = pos + 1;
        }
        if (lastpos < pos) {
            String ss = s.substring(lastpos, pos);
            list.add(ss.trim());
        } else {
            list.add("");
        }
        return list.toArray(new String[list.size()]);
    }

    private static Map string2map(String s) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] pair = StringUtils.mysplit(s, ",;");
        for (int i = 0; i < pair.length; ++i) {
            String[] namevalue = StringUtils.mysplit(pair[i], "=:");
            if (namevalue.length != 2) {
                throw new RuntimeException("\u4e0d\u5339\u914d\u7684\u540d/\u503c\u5bf9:" + StringUtils.bracket(pair[i]));
            }
            map.put(namevalue[0], StringUtils.string2obj(namevalue[1]));
        }
        return map;
    }

    private static Object[] string2array(String s) {
        ArrayList<Object> list = new ArrayList<Object>();
        String[] pair = StringUtils.mysplit(s, ",;");
        for (int i = 0; i < pair.length; ++i) {
            list.add(StringUtils.string2obj(pair[i]));
        }
        return list.toArray();
    }

    public static Object string2obj(String s) {
        if (s == null) {
            return "";
        }
        if ((s = s.trim()).equals("")) {
            return "";
        }
        char c = s.charAt(0);
        if (c == '{') {
            int lastpos = StringUtils.pairIndex(s, 0, '{', '}');
            if (lastpos > 0) {
                return StringUtils.string2map(s.substring(1, lastpos));
            }
            throw new RuntimeException("\u4e0d\u5339\u914d\u7684'{'Map\u7b26\u53f7:" + StringUtils.bracket(s));
        }
        if (c == '[') {
            int lastpos = StringUtils.pairIndex(s, 0, '[', ']');
            if (lastpos > 0) {
                return StringUtils.string2array(s.substring(1, lastpos));
            }
            throw new RuntimeException("\u4e0d\u5339\u914d\u7684'['\u6570\u7ec4\u7b26\u53f7:" + StringUtils.bracket(s));
        }
        return StringUtils.unescape(s);
    }

    private static String map2string(Map map) {
        StringBuffer sbuff = new StringBuffer(256);
        sbuff.append('{');
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = map.get(key);
            sbuff.append(key);
            sbuff.append('=');
            sbuff.append(StringUtils.obj2string(value));
            sbuff.append(';');
        }
        if (sbuff.length() > 1) {
            sbuff.deleteCharAt(sbuff.length() - 1);
        }
        sbuff.append('}');
        return sbuff.toString();
    }

    private static String array2string(Object[] ao) {
        StringBuffer sbuff = new StringBuffer(256);
        sbuff.append('[');
        for (int i = 0; i < ao.length; ++i) {
            sbuff.append(StringUtils.obj2string(ao[i]));
            sbuff.append(',');
        }
        if (sbuff.length() > 1) {
            sbuff.deleteCharAt(sbuff.length() - 1);
        }
        sbuff.append(']');
        return sbuff.toString();
    }

    public static String obj2string(Object obj) {
        if (obj instanceof Map) {
            return StringUtils.map2string((Map)obj);
        }
        if (obj instanceof Object[]) {
            return StringUtils.array2string((Object[])obj);
        }
        return StringUtils.escape(obj.toString());
    }

    private static boolean equals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object o1 = a[i];
            Object o2 = a2[i];
            if (o1 != null ? StringUtils.equals(o1, o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1 instanceof Object[]) {
            if (o2 instanceof Object[]) {
                return StringUtils.equals((Object[])o1, (Object[])o2);
            }
            return false;
        }
        if (o1 instanceof String) {
            String s1 = (String)o1;
            if (o2 != null) {
                String s2 = o2.toString();
                s1 = s1.trim();
                s2 = s2.trim();
                return s1.equals(s2);
            }
            return false;
        }
        return o1.equals(o2);
    }

    public static byte[] AscToBcd(byte[] in, int size) {
        if (size > in.length) {
            return null;
        }
        if (size % 2 == 1) {
            return null;
        }
        boolean i = false;
        int tmpbyte1 = 0;
        int tmpbyte2 = 0;
        byte[] out = new byte[size];
        for (int count = 0; count < size; ++count) {
            char tmp_char = (char)in[count];
            if (count % 2 == 1) {
                tmpbyte2 = tmp_char == 'f' || tmp_char == 'F' ? 15 : (tmp_char == 'e' || tmp_char == 'E' ? 14 : (tmp_char == 'd' || tmp_char == 'D' ? 13 : (tmp_char == 'c' || tmp_char == 'C' ? 12 : (tmp_char == 'b' || tmp_char == 'B' ? 11 : (tmp_char == 'a' || tmp_char == 'A' ? 10 : (int)((byte)(in[count] - 48)))))));
                out[count / 2] = (byte)(tmpbyte1 + tmpbyte2);
                continue;
            }
            tmpbyte1 = tmp_char == 'f' || tmp_char == 'F' ? -16 : (tmp_char == 'e' || tmp_char == 'E' ? -32 : (tmp_char == 'd' || tmp_char == 'D' ? -48 : (tmp_char == 'c' || tmp_char == 'C' ? -64 : (tmp_char == 'b' || tmp_char == 'B' ? -80 : (tmp_char == 'a' || tmp_char == 'A' ? -96 : (int)((byte)(in[count] - 48 << 4)))))));
        }
        return out;
    }

    public static byte[] BcdToAsc(byte[] in, int size) {
        if (size > in.length) {
            return null;
        }
        boolean i = false;
        int asc_size = size * 2;
        byte[] out = new byte[asc_size];
        for (int count = 0; count < asc_size; ++count) {
            char tmp_char = (char)in[count / 2];
            if (count % 2 == 1) {
                out[count] = (byte)((in[count / 2] & 0xF) + 48);
                if (out[count] == 63) {
                    out[count] = 102;
                    continue;
                }
                if (out[count] == 62) {
                    out[count] = 101;
                    continue;
                }
                if (out[count] == 61) {
                    out[count] = 100;
                    continue;
                }
                if (out[count] == 60) {
                    out[count] = 99;
                    continue;
                }
                if (out[count] == 59) {
                    out[count] = 98;
                    continue;
                }
                if (out[count] != 58) continue;
                out[count] = 97;
                continue;
            }
            out[count] = (byte)((in[count / 2] >> 4 & 0xF) + 48);
            if (out[count] == 63) {
                out[count] = 102;
                continue;
            }
            if (out[count] == 62) {
                out[count] = 101;
                continue;
            }
            if (out[count] == 61) {
                out[count] = 100;
                continue;
            }
            if (out[count] == 60) {
                out[count] = 99;
                continue;
            }
            if (out[count] == 59) {
                out[count] = 98;
                continue;
            }
            if (out[count] != 58) continue;
            out[count] = 97;
        }
        return out;
    }

    public static byte[] int2ebcstr(int len) {
        byte[] out = new byte[2];
        String tmp = Integer.toHexString(len);
        if (tmp.length() < 4) {
            if (4 - tmp.length() == 1) {
                tmp = "0" + tmp;
            } else if (4 - tmp.length() == 2) {
                tmp = "00" + tmp;
            } else if (4 - tmp.length() == 3) {
                tmp = "000" + tmp;
            } else if (4 - tmp.length() == 4) {
                tmp = "0000" + tmp;
            }
        }
        out = StringUtils.AscToBcd(tmp.getBytes(), 4);
        return out;
    }

    public static int ebcstr2int(byte[] in) {
        int len = 0;
        String length = new String(StringUtils.BcdToAsc(in, 2));
        String[] a = new String[4];
        for (int i = 0; i < 4; ++i) {
            a[i] = length.substring(i, i + 1).equals("a") ? "10" : (length.substring(i, i + 1).equals("b") ? "11" : (length.substring(i, i + 1).equals("c") ? "12" : (length.substring(i, i + 1).equals("d") ? "13" : (length.substring(i, i + 1).equals("e") ? "14" : (length.substring(i, i + 1).equals("f") ? "15" : length.substring(i, i + 1))))));
        }
        len = Integer.parseInt(a[0]) * 4096 + Integer.parseInt(a[1]) * 256 + Integer.parseInt(a[2]) * 16 + Integer.parseInt(a[3]);
        return len;
    }

    public static String bytesToString(byte[] in) {
        return StringUtils.bytesToString(in, 3072);
    }

    public static String bytesToString(byte[] in, int limit) {
        byte[] out;
        if (in == null) {
            throw new IllegalArgumentException("StringUtils.byteToString()\u8f93\u5165\u7684\u5b57\u8282\u6570\u7ec4\u4e3anull");
        }
        if (in.length >= limit) {
            byte[] worker = new byte[limit];
            System.arraycopy(in, 0, worker, 0, limit);
            out = StringUtils.BcdToAsc(worker, worker.length);
        } else {
            out = StringUtils.BcdToAsc(in, in.length);
        }
        StringBuffer out_s = new StringBuffer("");
        int i = 0;
        while (i < out.length) {
            out_s.append(" ");
            out_s.append((char)out[i]);
            out_s.append((char)out[++i]);
            if (++i % 20 != 0) continue;
            out_s.append('\n');
        }
        return out_s.toString();
    }
}

