/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SprintfHelper {
    private static Hashtable cache = new Hashtable();
    private Integer width;
    private boolean widthStar = false;
    private Integer precision;
    private boolean precisionStar = false;
    private char conversion;
    private String string_value = null;
    private boolean leftJustified;
    private boolean showSign;
    private boolean extraSpace;
    private boolean altForm;
    private boolean zeroPadding;

    public static String sprintf(String s, Object obj) {
        StringBuffer stringbuffer = new StringBuffer();
        SprintfHelper.sprintf(s, new Object[]{obj}, stringbuffer);
        return stringbuffer.toString();
    }

    public static String sprintf(String s, Object[] aobj) {
        StringBuffer stringbuffer = new StringBuffer();
        SprintfHelper.sprintf(s, aobj, stringbuffer);
        return stringbuffer.toString();
    }

    public static String sprintf(String s, Enumeration enumeration) {
        StringBuffer stringbuffer = new StringBuffer();
        SprintfHelper.sprintf(s, enumeration, stringbuffer);
        return stringbuffer.toString();
    }

    public static void sprintf(String s, Object obj, StringBuffer stringbuffer) {
        SprintfHelper.sprintf(s, new Object[]{obj}, stringbuffer);
    }

    public static void sprintf(String s, Object[] aobj, StringBuffer stringbuffer) {
        SprintfHelper.sprintf(s, new ArrayEnumerator(aobj), stringbuffer);
    }

    public static void sprintf(String s, Enumeration enumeration, StringBuffer stringbuffer) {
        SprintfHelper[] asprintf = (SprintfHelper[])cache.get(s);
        if (asprintf == null) {
            asprintf = SprintfHelper.parseFormatString(s);
            cache.put(s, asprintf);
        }
        boolean flag = false;
        block11: for (int i = 0; i < asprintf.length; ++i) {
            SprintfHelper sprintf1 = asprintf[i];
            if (sprintf1.string_value != null) {
                stringbuffer.append(sprintf1.string_value);
                continue;
            }
            switch (sprintf1.numStars()) {
                case 1: {
                    sprintf1.width = (Integer)enumeration.nextElement();
                    break;
                }
                case 2: {
                    sprintf1.width = (Integer)enumeration.nextElement();
                    sprintf1.precision = (Integer)enumeration.nextElement();
                }
            }
            switch (sprintf1.conversion) {
                case 'd': 
                case 'i': {
                    sprintf1.format_d(enumeration.nextElement(), stringbuffer);
                    continue block11;
                }
                case 's': {
                    sprintf1.format_s(enumeration.nextElement(), stringbuffer);
                    continue block11;
                }
                case 'f': {
                    sprintf1.format_f(enumeration.nextElement(), stringbuffer);
                    continue block11;
                }
                case 'x': {
                    sprintf1.format_x(enumeration.nextElement(), stringbuffer, true);
                    continue block11;
                }
                case 'X': {
                    sprintf1.format_x(enumeration.nextElement(), stringbuffer, false);
                }
            }
        }
    }

    private SprintfHelper(String s) {
        this.string_value = s;
    }

    private SprintfHelper(String s, String s1, char c) {
        this.conversion = c;
        this.leftJustified = s.indexOf(45) != -1;
        this.showSign = s.indexOf(43) != -1;
        this.extraSpace = s.indexOf(32) != -1 && !this.showSign;
        this.altForm = s.indexOf(35) != -1;
        boolean bl = this.zeroPadding = s.indexOf(48) != -1;
        if (s1.length() > 0) {
            String s3;
            String s2;
            int i = s1.indexOf(".");
            if (i == -1) {
                s2 = s1;
                s3 = null;
            } else if (i == 0) {
                s2 = null;
                s3 = s1;
            } else if (i == s1.length() - 1) {
                s2 = s1.substring(0, i);
                s3 = "0";
            } else {
                s2 = s1.substring(0, i);
                s3 = s1.substring(i + 1);
            }
            if (s2 != null) {
                if (s2.equals("*")) {
                    this.widthStar = true;
                } else {
                    this.width = new Integer(s2);
                }
            }
            if (s3 != null) {
                if (s3.equals("*")) {
                    this.precisionStar = true;
                } else {
                    this.precision = new Integer(s3);
                }
            }
        }
    }

    public int numStars() {
        int i = 0;
        if (this.widthStar) {
            ++i;
        }
        if (this.precisionStar) {
            ++i;
        }
        return i;
    }

    public static SprintfHelper[] parseFormatString(String s) {
        Vector<SprintfHelper> vector = new Vector<SprintfHelper>();
        int i = 0;
        String s1 = "";
        block9: while (i < s.length()) {
            char c = s.charAt(i++);
            switch (c) {
                case '%': {
                    String s2 = "";
                    String s3 = "";
                    block10: while (i < s.length()) {
                        char c1 = s.charAt(i++);
                        switch (c1) {
                            case '%': {
                                s1 = s1 + "" + c1;
                                continue block9;
                            }
                            case '0': {
                                if (s3.equals("")) {
                                    s2 = s2 + "" + c1;
                                    continue block10;
                                }
                                s3 = s3 + "" + c1;
                                continue block10;
                            }
                            case ' ': 
                            case '#': 
                            case '+': 
                            case '-': {
                                s2 = s2 + "" + c1;
                                continue block10;
                            }
                            case 'E': 
                            case 'G': 
                            case 'X': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'g': 
                            case 'i': 
                            case 'o': 
                            case 's': 
                            case 'u': 
                            case 'x': {
                                if (!s1.equals("")) {
                                    vector.addElement(new SprintfHelper(s1));
                                    s1 = new String("");
                                }
                                vector.addElement(new SprintfHelper(s2, s3, c1));
                                continue block9;
                            }
                        }
                        s3 = s3 + "" + c1;
                    }
                    continue block9;
                }
            }
            s1 = s1 + "" + c;
        }
        if (!s1.equals("")) {
            vector.addElement(new SprintfHelper(s1));
        }
        Object[] asprintf = new SprintfHelper[vector.size()];
        vector.copyInto(asprintf);
        return asprintf;
    }

    private final void format_d(Object obj, StringBuffer stringbuffer) {
        block12: {
            Number number = (Number)obj;
            int i = stringbuffer.length();
            stringbuffer.append(number.toString());
            int j = SprintfHelper.getValue(this.width, 0);
            int k = SprintfHelper.getValue(this.precision, 1);
            int l = stringbuffer.length() - i;
            int i1 = k - l;
            if (i1 > 0) {
                for (int j1 = 0; j1 < i1; ++j1) {
                    stringbuffer.insert(i, ' ');
                }
            }
            if (this.showSign) {
                char c = number.intValue() < 0 ? (char)'-' : '+';
                stringbuffer.insert(i, c);
            } else if (this.extraSpace) {
                char c1 = number.intValue() < 0 ? (char)'-' : ' ';
                stringbuffer.insert(i, c1);
            }
            int k1 = Math.max(j, k);
            if (k1 <= stringbuffer.length() - i) break block12;
            if (this.leftJustified) {
                for (int l1 = 0; l1 < k1; ++l1) {
                    stringbuffer.append(' ');
                }
            } else {
                int i2 = k1 - (stringbuffer.length() - i);
                if (this.zeroPadding && this.precision == null) {
                    int j2 = !this.showSign && !this.extraSpace ? i : i + 1;
                    for (int l2 = 0; l2 < i2; ++l2) {
                        stringbuffer.insert(j2, '0');
                    }
                } else {
                    for (int k2 = 0; k2 < i2; ++k2) {
                        stringbuffer.insert(i, ' ');
                    }
                }
            }
        }
    }

    private final void format_s(Object obj, StringBuffer stringbuffer) {
        int i = stringbuffer.length();
        stringbuffer.append(obj.toString());
        int j = SprintfHelper.getValue(this.precision, stringbuffer.length() - i);
        int k = SprintfHelper.getValue(this.width, 0);
        int l = k - j;
        stringbuffer.setLength(j + i);
        if (this.leftJustified) {
            for (int i1 = 0; i1 < l; ++i1) {
                stringbuffer.append(' ');
            }
        } else {
            for (int j1 = 0; j1 < l; ++j1) {
                stringbuffer.insert(i, ' ');
            }
        }
    }

    private final void format_f(Object obj, StringBuffer stringbuffer) {
        block10: {
            int i = stringbuffer.length();
            Number number = (Number)obj;
            int j = SprintfHelper.getValue(this.precision, 6);
            int k = SprintfHelper.getValue(this.width, 0);
            stringbuffer.append(SprintfHelper.adjDoublePrecision(number, j));
            int l = stringbuffer.length() - i;
            int i1 = j - l;
            if (this.showSign) {
                char c = number.doubleValue() < 0.0 ? (char)'-' : '+';
                stringbuffer.insert(i, c);
            } else if (this.extraSpace) {
                char c1 = number.doubleValue() < 0.0 ? (char)'-' : ' ';
                stringbuffer.insert(i, c1);
            }
            int j1 = k;
            if (j1 <= stringbuffer.length() - i) break block10;
            if (this.leftJustified) {
                for (int k1 = 0; k1 < j1; ++k1) {
                    stringbuffer.append(' ');
                }
            } else {
                int l1 = j1 - (stringbuffer.length() - i);
                if (this.zeroPadding) {
                    int i2 = !this.showSign && !this.extraSpace ? i : i + 1;
                    for (int k2 = 0; k2 < l1; ++k2) {
                        stringbuffer.insert(i2, '0');
                    }
                } else {
                    for (int j2 = 0; j2 < l1; ++j2) {
                        stringbuffer.insert(i, ' ');
                    }
                }
            }
        }
    }

    private final void format_x(Object obj, StringBuffer stringbuffer, boolean flag) {
        block11: {
            int l1;
            int i = stringbuffer.length();
            int j = (Integer)obj;
            if (flag) {
                stringbuffer.append(Integer.toHexString(j));
            } else {
                stringbuffer.append(Integer.toHexString(j).toUpperCase());
            }
            int k = SprintfHelper.getValue(this.width, 0);
            int l = SprintfHelper.getValue(this.precision, 1);
            int i1 = stringbuffer.length() - i;
            int j1 = l - i1;
            if (j1 > 0) {
                for (int k1 = 0; k1 < j1; ++k1) {
                    stringbuffer.insert(i, '0');
                }
            }
            if ((l1 = Math.max(k, l)) <= stringbuffer.length() - i) break block11;
            if (this.leftJustified) {
                for (int i2 = 0; i2 < l1; ++i2) {
                    stringbuffer.append(' ');
                }
            } else {
                int j2 = l1 - (stringbuffer.length() - i);
                if (this.zeroPadding && this.precision == null) {
                    int k2 = !this.showSign && !this.extraSpace ? i : i + 1;
                    for (int i3 = 0; i3 < j2; ++i3) {
                        stringbuffer.insert(k2, '0');
                    }
                } else {
                    for (int l2 = 0; l2 < j2; ++l2) {
                        stringbuffer.insert(i, ' ');
                    }
                }
            }
        }
    }

    private static int getValue(Integer integer, int i) {
        if (integer == null) {
            return i;
        }
        return integer;
    }

    private static StringBuffer adjDoublePrecision(Number number, int i) {
        String s2;
        String s1;
        String s = number.toString();
        int j = s.indexOf(46);
        if (j == -1) {
            s1 = s;
            s2 = "0";
        } else {
            s1 = s.substring(0, j);
            s2 = s.substring(j + 1);
        }
        int k = s2.length();
        if (k < i) {
            StringBuffer stringbuffer = new StringBuffer(s1 + "." + s2);
            for (int l = k; l < i; ++l) {
                stringbuffer.append('0');
            }
            return stringbuffer;
        }
        if (k > i) {
            double d = Double.valueOf(s1 + "." + s2);
            d *= Math.pow(10.0, i);
            d = Math.rint(d);
            return SprintfHelper.adjDoublePrecision(new Double(d /= Math.pow(10.0, i)), i);
        }
        return new StringBuffer(s);
    }

    private static class ArrayEnumerator
    implements Enumeration,
    Serializable,
    Cloneable {
        private Object[] array;
        private int idx;

        public ArrayEnumerator(Object[] aobj) {
            this.array = aobj;
            this.idx = 0;
        }

        public boolean hasMoreElements() {
            return this.idx < this.array.length;
        }

        public Object nextElement() {
            Object object;
            try {
                object = this.array[this.idx++];
            }
            catch (ArrayIndexOutOfBoundsException arrayindexoutofboundsexception) {
                throw new NoSuchElementException();
            }
            return object;
        }

        public int which() {
            if (this.idx == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.idx - 1;
        }

        public synchronized Object clone() {
            Object object;
            try {
                object = super.clone();
            }
            catch (CloneNotSupportedException clonenotsupportedexception) {
                throw new RuntimeException("Contents of enum not cloneable" + clonenotsupportedexception);
            }
            return object;
        }
    }
}

