/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util;

import com.dc.util.SerializeHelperException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializeHelper {
    public static byte[] convert(Object serializableObject) {
        if (serializableObject == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteArray);
            out.writeObject(serializableObject);
            byte[] ret = byteArray.toByteArray();
            out.close();
            return ret;
        }
        catch (IOException e) {
            SerializeHelperException she = new SerializeHelperException("object to byte[] error", e);
            she.addScene("className", serializableObject.getClass().getName());
            throw she;
        }
    }

    public static Object convert(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
            return in.readObject();
        }
        catch (IOException e) {
            SerializeHelperException she = new SerializeHelperException("byte[] to object error", e);
            she.addScene("data", data);
            throw she;
        }
        catch (ClassNotFoundException e) {
            SerializeHelperException she = new SerializeHelperException("byte[] to object error", e);
            she.addScene("data", data);
            throw she;
        }
    }
}

