/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util;

import com.dc.util.classloader.ChangeAwareClassLoader;
import com.dc.util.classloader.PathClassFinder;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectFactory {
    private static Log logger = LogFactory.getLog((Class)ObjectFactory.class);
    private ChangeAwareClassLoader cacl = null;
    private PathClassFinder pcf = null;
    private int checkInterval;
    private String path = System.getProperty("dynamic.classpath");

    public ObjectFactory() {
        this.checkInterval = Integer.getInteger("dynamic.interval", 0);
        if (this.path != null && !this.path.equals("") && this.checkInterval >= 0) {
            this.pcf = new PathClassFinder(this.path);
            this.cacl = new ChangeAwareClassLoader(this.pcf);
        } else {
            this.checkInterval = -1;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Check interval = " + this.checkInterval));
        }
    }

    private boolean needCheck() {
        if (this.checkInterval < 0) {
            return false;
        }
        if (this.checkInterval == 0) {
            return true;
        }
        long now = System.currentTimeMillis();
        return now - this.cacl.getLastChecked() > (long)this.checkInterval;
    }

    private synchronized void ensureClassLoaderUpTodate() {
        if (this.needCheck() && !this.cacl.upToDate()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Create new change aware classloader!");
            }
            this.cacl = new ChangeAwareClassLoader(this.pcf);
        }
    }

    public boolean upToDate() {
        return !this.needCheck() || this.cacl.upToDate();
    }

    public Object createObject(String clsname) throws ClassNotFoundException {
        try {
            if (this.checkInterval < 0) {
                return Class.forName(clsname).newInstance();
            }
            this.ensureClassLoaderUpTodate();
            return this.cacl.loadClass(clsname).newInstance();
        }
        catch (Exception e) {
            throw new ClassNotFoundException(clsname);
        }
    }

    public InputStream getResourceAsStream(String name) {
        try {
            if (this.checkInterval < 0) {
                return this.getClass().getResourceAsStream(name);
            }
            this.ensureClassLoaderUpTodate();
            return this.cacl.getResourceAsStream(name);
        }
        catch (Exception e) {
            return null;
        }
    }
}

