/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util;

import java.io.UnsupportedEncodingException;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static int intValue(String str) {
        return (int)NumberUtils.longValue(str, 0, str.length());
    }

    public static int intValue(String str, int start, int length) {
        return (int)NumberUtils.longValue(str, start, length);
    }

    public static int intValue(byte[] buff) {
        return (int)NumberUtils.longValue(buff, 0, buff.length);
    }

    public static int intValue(byte[] buff, int start, int length) {
        return (int)NumberUtils.longValue(buff, start, length);
    }

    public static long longValue(String str) {
        return NumberUtils.longValue(str, 0, str.length());
    }

    public static long longValue(String str, int start, int length) {
        boolean negative = false;
        long value = 0L;
        int first_not_space = start;
        while (true) {
            if (str.charAt(first_not_space) != '+') {
                if (str.charAt(first_not_space) == '-') {
                    negative = true;
                } else if (str.charAt(first_not_space) != ' ') break;
            }
            ++first_not_space;
        }
        int last_not_space = start + length - 1;
        while (str.charAt(last_not_space) == ' ') {
            --last_not_space;
        }
        for (int i = first_not_space; i <= last_not_space; ++i) {
            char ch = str.charAt(i);
            if (ch < '0' || ch > '9') {
                throw new NumberFormatException(str.substring(start, start + length));
            }
            value = value * 10L + (long)(ch - 48);
        }
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static long longValue(byte[] buff) {
        return NumberUtils.longValue(buff, 0, buff.length);
    }

    public static long longValue(byte[] buff, int start, int length) {
        boolean negative = false;
        long value = 0L;
        int first_not_space = start;
        while (true) {
            if (buff[first_not_space] != 43) {
                if (buff[first_not_space] == 45) {
                    negative = true;
                } else if (buff[first_not_space] != 32) break;
            }
            ++first_not_space;
        }
        int last_not_space = start + length - 1;
        while (buff[last_not_space] == 32) {
            --last_not_space;
        }
        for (int i = first_not_space; i <= last_not_space; ++i) {
            byte ch = buff[i];
            if (ch < 48 || ch > 57) {
                try {
                    String str = new String(buff, start, length, "iso8859_1");
                    throw new NumberFormatException(str);
                }
                catch (UnsupportedEncodingException e) {
                    throw new NumberFormatException("");
                }
            }
            value = value * 10L + (long)(ch - 48);
        }
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static double doubleValue(String str) {
        return NumberUtils.doubleValue(str, 0, str.length());
    }

    public static double doubleValue(String str, int start, int length) {
        boolean negative = false;
        long intPart = 0L;
        double floatPart = 0.0;
        int index = str.indexOf(46, start);
        if (index < 0) {
            index = start + length;
        }
        if (str.indexOf(45) >= 0) {
            negative = true;
        }
        intPart = NumberUtils.longValue(str, start, index - start);
        if (negative) {
            intPart = -intPart;
        }
        boolean stage = false;
        if (index < start + length) {
            int first_not_space = index + 1;
            int last_not_space = start + length - 1;
            while (str.charAt(last_not_space) == ' ') {
                --last_not_space;
            }
            for (int i = last_not_space; i >= first_not_space; --i) {
                char ch = str.charAt(i);
                if (ch < '0' || ch > '9') {
                    throw new NumberFormatException(str.substring(start, start + length));
                }
                floatPart = (floatPart + (double)ch - 48.0) / 10.0;
            }
        }
        double value = (double)intPart + floatPart;
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static double doubleValue(byte[] buff) {
        return NumberUtils.doubleValue(buff, 0, buff.length);
    }

    public static double doubleValue(byte[] buff, int start, int length) {
        int index;
        boolean negative = false;
        long intPart = 0L;
        double floatPart = 0.0;
        for (index = start; index < start + length && buff[index] != 46; ++index) {
        }
        for (int i = start; i < start + length; ++i) {
            if ((char)buff[i] != '-') continue;
            negative = true;
            break;
        }
        intPart = NumberUtils.longValue(buff, start, index - start);
        if (negative) {
            intPart = -intPart;
        }
        if (index < start + length) {
            int first_not_space = index + 1;
            int last_not_space = start + length - 1;
            while (buff[last_not_space] == 32) {
                --last_not_space;
            }
            for (int i = last_not_space; i >= first_not_space; --i) {
                byte ch = buff[i];
                if (ch < 48 || ch > 57) {
                    try {
                        String str = new String(buff, start, length, "iso8859_1");
                        throw new NumberFormatException(str);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new NumberFormatException("");
                    }
                }
                floatPart = (floatPart + (double)ch - 48.0) / 10.0;
            }
        }
        double value = (double)intPart + floatPart;
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static double doubleValue(String str, int scale) {
        return NumberUtils.doubleValue(str, 0, str.length(), scale);
    }

    public static double doubleValue(String str, int start, int length, int scale) {
        boolean negative = false;
        long intPart = 0L;
        double floatPart = 0.0;
        intPart = NumberUtils.longValue(str, start, length - scale);
        if (intPart < 0L) {
            negative = true;
            intPart = -intPart;
        }
        for (int i = start + length - 1; i >= start + length - scale; --i) {
            char ch = str.charAt(i);
            if (ch < '0' || ch > '9') {
                throw new NumberFormatException(str.substring(start, start + length));
            }
            floatPart = (floatPart + (double)ch - 48.0) / 10.0;
        }
        double value = (double)intPart + floatPart;
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static double doubleValue(byte[] buff, int scale) {
        return NumberUtils.doubleValue(buff, 0, buff.length, scale);
    }

    public static double doubleValue(byte[] buff, int start, int length, int scale) {
        boolean negative = false;
        long intPart = 0L;
        double floatPart = 0.0;
        intPart = NumberUtils.longValue(buff, start, length - scale);
        if (intPart < 0L) {
            negative = true;
            intPart = -intPart;
        }
        for (int i = start + length - 1; i >= start + length - scale; --i) {
            byte ch = buff[i];
            if (ch < 48 || ch > 57) {
                try {
                    String str = new String(buff, start, length, "iso8859_1");
                    throw new NumberFormatException(str);
                }
                catch (UnsupportedEncodingException e) {
                    throw new NumberFormatException("");
                }
            }
            floatPart = (floatPart + (double)ch - 48.0) / 10.0;
        }
        double value = (double)intPart + floatPart;
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static byte[] toBytes(double value, int length, int scale) {
        return NumberUtils.toBytes(value, length, scale, true, false);
    }

    public static byte[] toBytes(double value, int length, int scale, boolean with_digit) {
        return NumberUtils.toBytes(value, length, scale, with_digit, false);
    }

    public static byte[] toBytes(double value, int length, int scale, boolean with_digit, boolean plus_sign) {
        int len = length;
        if (plus_sign || value < 0.0) {
            ++len;
        }
        if (with_digit) {
            ++len;
        }
        byte[] buff = new byte[len];
        NumberUtils.toBytes(buff, 0, value, length, scale, with_digit, plus_sign);
        return buff;
    }

    public static void toBytes(byte[] buff, int offset, double value, int length, int scale) {
        NumberUtils.toBytes(buff, offset, value, length, scale, true, false);
    }

    public static void toBytes(byte[] buff, int offset, double value, int length, int scale, boolean with_digit) {
        NumberUtils.toBytes(buff, offset, value, length, scale, with_digit, false);
    }

    public static void toBytes(byte[] buff, int offset, double value, int length, int scale, boolean with_digit, boolean plus_sign) {
        long decPart;
        if (value < 0.0) {
            value = -value;
            buff[offset++] = 45;
        } else if (plus_sign) {
            buff[offset++] = 43;
        }
        long intPart = (long)value;
        double remainder = value - (double)intPart;
        for (int i = 0; i < scale; ++i) {
            remainder *= 10.0;
        }
        if ((remainder -= (double)(decPart = (long)remainder)) >= 0.5) {
            ++decPart;
        }
        NumberUtils.toBytes(buff, offset, intPart, length - scale);
        if (with_digit) {
            buff[offset + length - scale] = 46;
            ++offset;
        }
        NumberUtils.toBytes(buff, offset + length - scale, decPart, scale);
    }

    public static void toBytes(byte[] buff, int offset, long value, int length) {
        NumberUtils.toBytes(buff, offset, value, length, false);
    }

    public static byte[] toBytes(long value, int length) {
        return NumberUtils.toBytes(value, length, false);
    }

    public static byte[] toBytes(long value, int length, boolean plus_sign) {
        int len = length;
        if (plus_sign || value < 0L) {
            ++len;
        }
        byte[] buff = new byte[len];
        NumberUtils.toBytes(buff, 0, value, length, plus_sign);
        return buff;
    }

    public static void toBytes(byte[] buff, int offset, long value, int length, boolean plus_sign) {
        if (value < 0L) {
            value = -value;
            buff[offset++] = 45;
        } else if (plus_sign) {
            buff[offset++] = 43;
        }
        for (int i = offset + length - 1; i >= offset; --i) {
            int ch = (int)(value % 10L);
            buff[i] = (byte)(ch + 48);
            value /= 10L;
        }
    }
}

