/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util;

import com.dc.util.bean.Property;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Message
implements Serializable {
    protected static Log log = LogFactory.getLog((Class)Message.class);
    protected HashMap locales = new HashMap();
    protected HashMap messages = new HashMap();
    protected static HashMap configs = new HashMap();
    private static String DEFAULT_MESSAGE_CONFIG = "message";
    protected String config = null;
    protected Class clazz = null;
    protected Locale defaultLocale = Locale.getDefault();
    protected HashMap formats = new HashMap();
    protected boolean returnNull = false;

    public String getConfig() {
        return this.config;
    }

    public boolean getReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    private Message(String config) {
        this(config, false);
    }

    private Message(String config, boolean returnNull) {
        this.config = config;
        this.returnNull = returnNull;
    }

    private Message(Class clazz, boolean returnNull) {
        this.clazz = clazz;
        this.returnNull = returnNull;
    }

    public String getMessage(String key) {
        return this.getMessage((Locale)null, key);
    }

    public String getMessage(String key, Object arg1) {
        Object[] args = new Object[]{arg1};
        return this.getMessage((Locale)null, key, args);
    }

    public String getMessage(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getMessage((Locale)null, key, args);
    }

    public String getMessage(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getMessage((Locale)null, key, args);
    }

    public String getMessage(String key, Object[] args) {
        return this.getMessage((Locale)null, key, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(Locale locale, String key, Object[] args) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        MessageFormat format = null;
        String formatKey = this.messageKey(locale, key);
        HashMap hashMap = this.formats;
        synchronized (hashMap) {
            format = (MessageFormat)this.formats.get(formatKey);
            if (format == null) {
                String formatString = this.getMessage(locale, key);
                if (formatString == null) {
                    if (this.returnNull) {
                        return null;
                    }
                    return formatKey;
                }
                format = new MessageFormat(this.escape(formatString));
                this.formats.put(formatKey, format);
            }
        }
        return format.format(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(Locale locale, String key) {
        HashMap hashMap;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMessage(" + locale + "," + key + ")"));
        }
        if (locale == null) {
            locale = this.defaultLocale;
        }
        String localeKey = this.localeKey(locale);
        String originalKey = this.messageKey(localeKey, key);
        String messageKey = null;
        String message = null;
        int underscore = 0;
        boolean addIt = false;
        while (true) {
            this.loadLocale(localeKey);
            messageKey = this.messageKey(localeKey, key);
            hashMap = this.messages;
            synchronized (hashMap) {
                message = (String)this.messages.get(messageKey);
                if (message != null) {
                    if (addIt) {
                        this.messages.put(originalKey, message);
                    }
                    return message;
                }
            }
            addIt = true;
            underscore = localeKey.lastIndexOf("_");
            if (underscore < 0) break;
            localeKey = localeKey.substring(0, underscore);
        }
        if (!this.defaultLocale.equals(locale)) {
            localeKey = this.localeKey(this.defaultLocale);
            messageKey = this.messageKey(localeKey, key);
            this.loadLocale(localeKey);
            hashMap = this.messages;
            synchronized (hashMap) {
                message = (String)this.messages.get(messageKey);
                if (message != null) {
                    this.messages.put(originalKey, message);
                    return message;
                }
            }
        }
        localeKey = "";
        messageKey = this.messageKey(localeKey, key);
        this.loadLocale(localeKey);
        hashMap = this.messages;
        synchronized (hashMap) {
            message = (String)this.messages.get(messageKey);
            if (message != null) {
                this.messages.put(originalKey, message);
                return message;
            }
        }
        if (this.returnNull) {
            return null;
        }
        return "???" + this.messageKey(locale, key) + "???";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadLocale(String localeKey) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadLocale(" + localeKey + ")"));
        }
        if (this.locales.get(localeKey) != null) {
            return;
        }
        this.locales.put(localeKey, localeKey);
        String name = this.config.replace('.', '/');
        name = name + ".properties";
        if (localeKey.length() > 0) {
            name = name + "." + localeKey;
        }
        InputStream is = null;
        Property props = new Property();
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Loading resource '" + name + "'"));
        }
        ClassLoader classLoader = null;
        if (this.clazz != null) {
            classLoader = this.clazz.getClassLoader();
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
        }
        is = classLoader.getResourceAsStream(name);
        if (is != null) {
            try {
                props.load(is);
            }
            catch (Exception e) {
                log.error((Object)"loadLocale()", (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"loadLocale()", (Throwable)e);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Loading resource completed");
        }
        if (props.size() < 1) {
            return;
        }
        HashMap hashMap = this.messages;
        synchronized (hashMap) {
            Iterator names = props.propertyNames();
            while (names.hasNext()) {
                String key = (String)names.next();
                this.messages.put(this.messageKey(localeKey, key), props.getProperty(key));
            }
        }
    }

    public boolean isPresent(String key) {
        return this.isPresent(null, key);
    }

    public boolean isPresent(Locale locale, String key) {
        String message = this.getMessage(locale, key);
        if (message == null) {
            return false;
        }
        return !message.startsWith("???") || !message.endsWith("???");
    }

    protected String escape(String string) {
        if (string == null || string.indexOf(39) < 0) {
            return string;
        }
        int n = string.length();
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char ch = string.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    protected String localeKey(Locale locale) {
        if (locale == null) {
            return "";
        }
        return locale.toString();
    }

    protected String messageKey(Locale locale, String key) {
        return this.localeKey(locale) + "." + key;
    }

    protected String messageKey(String localeKey, String key) {
        return localeKey + "." + key;
    }

    public static Message getInstance() {
        return Message.getInstance(DEFAULT_MESSAGE_CONFIG);
    }

    public static Message getInstance(Class cls) {
        String name = cls.getName();
        name = name.substring(0, name.lastIndexOf(46));
        return Message.getInstance(cls, name + "." + DEFAULT_MESSAGE_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message getInstance(Class cls, String config) {
        Message message = null;
        HashMap hashMap = configs;
        synchronized (hashMap) {
            message = (Message)configs.get(cls.getName());
            if (message == null) {
                message = new Message(cls, false);
                message.config = config;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Class Token Outerside:" + cls.getName() + "<-->" + config));
                }
                configs.put(cls.getName(), message);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Message getInstance(String config) {
        Message message = null;
        HashMap hashMap = configs;
        synchronized (hashMap) {
            message = (Message)configs.get(config);
            if (message == null) {
                message = new Message(config);
                configs.put(config, message);
            }
        }
        return message;
    }

    public void log(String message) {
        log.debug((Object)message);
    }

    public void log(String message, Throwable throwable) {
        log.debug((Object)message, throwable);
    }
}

