/*
 * Decompiled with CFR 0.152.
 */
package com.dc.util;

import java.io.UnsupportedEncodingException;

public final class Hex {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int COLS_PER_ROW = 8;
    private static final int BYTES_PER_ROW = 16;

    private Hex() {
    }

    public static String asHex(byte[] abyte0, int i) {
        return Hex.asHex(abyte0, i, true);
    }

    public static String asUnicode(String s) {
        String s1 = "";
        for (int i = 0; i < s.length(); ++i) {
            s1 = s1 + "\\u" + Hex.asHex(s.charAt(i) >> 8) + Hex.asHex(s.charAt(i));
        }
        return s1;
    }

    public static String asUnicode(char c) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("\\u");
        stringbuffer.append(Hex.asHex(c >> 8) + Hex.asHex(c));
        return stringbuffer.toString();
    }

    public static String asHex(String s, String s1) throws UnsupportedEncodingException {
        byte[] abyte0 = s.getBytes(s1);
        return Hex.asHex(abyte0);
    }

    public static byte[] asHexBytes(byte[] abyte0, int i, boolean flag) {
        byte[] abyte1;
        int j = Math.min(i, abyte0.length);
        int k = 0;
        if (flag) {
            abyte1 = new byte[j * 2 + 2];
            abyte1[0] = 48;
            abyte1[1] = 120;
            k += 2;
        } else {
            abyte1 = new byte[j * 2];
        }
        for (int l = 0; l < j; ++l) {
            abyte1[k++] = (byte)HEX_CHARS[(abyte0[l] & 0xF0) >> 4];
            abyte1[k++] = (byte)HEX_CHARS[(abyte0[l] & 0xF) >> 0];
        }
        return abyte1;
    }

    public static String asHex(byte[] abyte0, int i, boolean flag) {
        byte[] b = Hex.asHexBytes(abyte0, i, flag);
        String s = "";
        try {
            s = new String(b, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return s;
    }

    public static byte[] fromHexString(byte[] abyte0, int i) {
        int j = 0;
        if (abyte0[0] == 48 && (abyte0[1] == 120 || abyte0[1] == 88)) {
            j += 2;
            i -= 2;
        }
        int k = i / 2;
        byte[] abyte1 = new byte[k];
        int l = 0;
        while (l < k) {
            abyte1[l] = (byte)((Hex.hexValueOf(abyte0[j]) << 4 | Hex.hexValueOf(abyte0[j + 1])) & 0xFF);
            ++l;
            j += 2;
        }
        return abyte1;
    }

    public static String asHex(int i) {
        char[] ac = new char[]{HEX_CHARS[(i & 0xF0) >> 4], HEX_CHARS[(i & 0xF) >> 0]};
        return new String(ac);
    }

    public static String asHex(byte[] abyte0) {
        return Hex.asHex(abyte0, abyte0.length);
    }

    public static int hexValueOf(int i) {
        if (i >= 48 && i <= 57) {
            return i - 48;
        }
        if (i >= 97 && i <= 102) {
            return i - 97 + 10;
        }
        if (i >= 65 && i <= 70) {
            return i - 65 + 10;
        }
        return 0;
    }

    public static String dump(byte[] abyte0) {
        if (abyte0 == null) {
            return "" + abyte0;
        }
        return Hex.dump(abyte0, 0, abyte0.length);
    }

    public static String dump(byte[] abyte0, int i, int j) {
        if (i < 0) {
            i = 0;
        }
        int k = Math.min(abyte0.length, i + j);
        int l = i & 0xFFFFFFF0;
        int i1 = k + 15 & 0xFFFFFFF0;
        StringBuffer stringbuffer = new StringBuffer();
        int j1 = l;
        for (int k1 = l; k1 < i1; ++k1) {
            if (k1 % 16 == 0) {
                Hex.lineLabel(stringbuffer, k1);
                j1 = k1;
            }
            if (k1 < i || k1 >= k) {
                stringbuffer.append("  ");
            } else {
                stringbuffer.append(Hex.asHex(abyte0[k1]));
            }
            if (k1 % 2 == 1) {
                stringbuffer.append(' ');
            }
            if (k1 % 16 != 15) continue;
            stringbuffer.append("  ");
            for (int l1 = j1; l1 < j1 + 16; ++l1) {
                if (l1 < i || l1 >= k) {
                    stringbuffer.append(' ');
                    continue;
                }
                stringbuffer.append(Hex.toPrint(abyte0[l1]));
            }
            stringbuffer.append('\n');
        }
        return stringbuffer.toString();
    }

    public static final boolean isHexChar(int i) {
        switch (i) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    private static char toPrint(byte byte0) {
        byte byte1 = byte0;
        if (byte1 < 32 || byte1 > 126) {
            return '.';
        }
        return (char)byte1;
    }

    private static void lineLabel(StringBuffer stringbuffer, int i) {
        StringBuffer stringbuffer1;
        String s = new Integer(i).toString();
        if (s.length() <= 5) {
            stringbuffer1 = new StringBuffer("    ");
            stringbuffer1.insert(5 - s.length(), s);
            stringbuffer1.setLength(5);
        } else {
            stringbuffer1 = new StringBuffer(s);
        }
        stringbuffer.append(stringbuffer1);
        stringbuffer.append(": ");
    }
}

