/*
 * Decompiled with CFR 0.152.
 */
package com.dc.security;

import com.dc.security.AlgorithmInitException;
import com.dc.security.Mac;
import com.dc.security.Parameters;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DefaultMac
implements Mac {
    private String algorithm;
    private MessageDigest md;

    public DefaultMac(String algorithm) {
        this.algorithm = algorithm;
    }

    public void init() {
        try {
            this.md = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmInitException("", this.algorithm, e);
        }
    }

    public void init(Parameters parameters) {
        this.init();
    }

    public int getMacLength() {
        return this.md.getDigestLength();
    }

    public byte[] generate(byte[] input) {
        return this.md.digest(input);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void cleanUp() {
        this.md.reset();
    }
}

