/*
 * Decompiled with CFR 0.152.
 */
package com.dc.security;

import com.dc.security.AlgorithmInitException;
import com.dc.security.Cipher;
import com.dc.security.CryptException;
import com.dc.security.DefaultAlgorithmParameters;
import com.dc.security.Parameters;
import com.dc.util.StringUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCipher
implements Cipher {
    private static Log log = LogFactory.getLog((Class)DefaultCipher.class);
    private String transformation;
    private String algorithm;
    private String mode;
    private String padding;
    private Key key;
    private javax.crypto.Cipher cip;
    private DefaultAlgorithmParameters parameters;

    public DefaultCipher(String transformation) {
        this.transformation = transformation;
        StringTokenizer token = new StringTokenizer(transformation, "/");
        if (token.hasMoreTokens()) {
            this.algorithm = token.nextToken();
        }
        if (token.hasMoreTokens()) {
            this.mode = token.nextToken();
        }
        if (token.hasMoreTokens()) {
            this.padding = token.nextToken();
        }
    }

    public void init() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(this.algorithm);
            this.key = keyGen.generateKey();
            this.cip = javax.crypto.Cipher.getInstance(this.transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmInitException(this.transformation, this.algorithm, e);
        }
        catch (NoSuchPaddingException e) {
            throw new AlgorithmInitException(this.transformation, this.algorithm, e);
        }
    }

    public void init(Parameters params) {
        this.parameters = (DefaultAlgorithmParameters)params;
        try {
            if (null != this.parameters.getKeySpec()) {
                this.key = SecretKeyFactory.getInstance(this.transformation).generateSecret(this.parameters.getKeySpec());
            } else {
                KeyGenerator keyGen = KeyGenerator.getInstance(this.algorithm);
                this.key = keyGen.generateKey();
            }
            this.cip = javax.crypto.Cipher.getInstance(this.transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmInitException(this.transformation, this.algorithm, e);
        }
        catch (NoSuchPaddingException e) {
            throw new AlgorithmInitException(this.transformation, this.algorithm, e);
        }
        catch (InvalidKeySpecException e) {
            throw new AlgorithmInitException(this.transformation, this.algorithm, e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] encrypt(byte[] input) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("before encrypt : " + StringUtils.bytesToString(input)));
        }
        try {
            if (null == this.parameters || null == this.parameters.getParamSpec()) {
                this.cip.init(1, this.key);
            } else {
                this.cip.init(1, this.key, this.parameters.getParamSpec());
            }
            byte[] result = this.cip.doFinal(input);
            if (log.isDebugEnabled()) {
                log.debug((Object)("after encrypt : " + StringUtils.bytesToString(result)));
            }
            return result;
        }
        catch (InvalidKeyException e) {
            throw new CryptException(1, this.transformation, this.algorithm, e);
        }
        catch (IllegalStateException e) {
            throw new CryptException(1, this.transformation, this.algorithm, e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptException(1, this.transformation, this.algorithm, e);
        }
        catch (BadPaddingException e) {
            throw new CryptException(1, this.transformation, this.algorithm, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptException(1, this.transformation, this.algorithm, e);
        }
    }

    public byte[] decrypt(byte[] input) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("before decrypt : " + StringUtils.bytesToString(input)));
        }
        try {
            if (null == this.parameters || null == this.parameters.getParamSpec()) {
                this.cip.init(2, this.key);
            } else {
                this.cip.init(2, this.key, this.parameters.getParamSpec());
            }
            byte[] result = this.cip.doFinal(input);
            if (log.isDebugEnabled()) {
                log.debug((Object)("after decrypt : " + StringUtils.bytesToString(result)));
            }
            return result;
        }
        catch (InvalidKeyException e) {
            throw new CryptException(2, this.transformation, this.algorithm, e);
        }
        catch (IllegalStateException e) {
            throw new CryptException(2, this.transformation, this.algorithm, e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptException(2, this.transformation, this.algorithm, e);
        }
        catch (BadPaddingException e) {
            throw new CryptException(2, this.transformation, this.algorithm, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptException(2, this.transformation, this.algorithm, e);
        }
    }

    public byte[] encrypt(byte[] input, Parameters parameters) {
        return null;
    }

    public byte[] decrypt(byte[] input, Parameters parameters) {
        return null;
    }

    public void cleanUp() {
    }
}

