/*
 * Decompiled with CFR 0.152.
 */
package com.dc.security;

import com.dc.security.Cipher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class CipherFactory {
    private static final Map ciphers = new HashMap(21);

    public static Cipher getCipher(String algorithm) {
        if (ciphers.containsKey(algorithm)) {
            return (Cipher)ciphers.get(algorithm);
        }
        return null;
    }

    public static void addCipher(String algorithm, Cipher gen) {
        ciphers.put(algorithm, gen);
    }

    public static void removeCipher(String algorithm) {
        if (ciphers.containsKey(algorithm)) {
            ciphers.remove(algorithm);
        }
    }

    public static Iterator algorithmNames() {
        return ciphers.keySet().iterator();
    }
}

