/*
 * Decompiled with CFR 0.152.
 */
package com.dc.log;

import com.dc.log.Level;
import com.dc.log.LogEnabled;
import java.io.Serializable;
import org.apache.commons.logging.Log;

public final class LogImpl
implements Log,
Serializable {
    private Log wrapped;

    public LogImpl(Log log) {
        this.wrapped = log;
    }

    public void debug(Object arg0, Throwable arg1) {
        if (this.isDebugEnabled()) {
            this.wrapped.debug(arg0, arg1);
        }
    }

    public void debug(Object arg0) {
        if (this.isDebugEnabled()) {
            this.wrapped.debug(arg0);
        }
    }

    public void error(Object arg0, Throwable arg1) {
        if (this.isErrorEnabled()) {
            this.wrapped.error(arg0, arg1);
        }
    }

    public void error(Object arg0) {
        if (this.isErrorEnabled()) {
            this.wrapped.error(arg0);
        }
    }

    public void fatal(Object arg0, Throwable arg1) {
        if (this.isFatalEnabled()) {
            this.wrapped.fatal(arg0, arg1);
        }
    }

    public void fatal(Object arg0) {
        if (this.isFatalEnabled()) {
            this.wrapped.fatal(arg0);
        }
    }

    public void info(Object arg0, Throwable arg1) {
        if (this.isInfoEnabled()) {
            this.wrapped.info(arg0, arg1);
        }
    }

    public void info(Object arg0) {
        if (this.isInfoEnabled()) {
            this.wrapped.info(arg0);
        }
    }

    public boolean isNoneEnabled() {
        LogEnabled enabled = LogEnabled.getInstance();
        if (null != enabled) {
            return enabled.isLevelEnabled(Level.NONE);
        }
        return false;
    }

    public boolean isDebugEnabled() {
        boolean isNone = this.isNoneEnabled();
        if (isNone) {
            return this.wrapped.isDebugEnabled();
        }
        LogEnabled enabled = LogEnabled.getInstance();
        if (null != enabled) {
            return enabled.isLevelEnabled(Level.DEBUG);
        }
        return this.wrapped.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        boolean isNone = this.isNoneEnabled();
        if (isNone) {
            return this.wrapped.isErrorEnabled();
        }
        LogEnabled enabled = LogEnabled.getInstance();
        if (null != enabled) {
            return enabled.isLevelEnabled(Level.ERROR);
        }
        return this.wrapped.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        boolean isNone = this.isNoneEnabled();
        if (isNone) {
            return this.wrapped.isFatalEnabled();
        }
        LogEnabled enabled = LogEnabled.getInstance();
        if (null != enabled) {
            return enabled.isLevelEnabled(Level.FATAL);
        }
        return this.wrapped.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        boolean isNone = this.isNoneEnabled();
        if (isNone) {
            return this.wrapped.isInfoEnabled();
        }
        LogEnabled enabled = LogEnabled.getInstance();
        if (null != enabled) {
            return enabled.isLevelEnabled(Level.INFO);
        }
        return this.wrapped.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        boolean isNone = this.isNoneEnabled();
        if (isNone) {
            return this.wrapped.isWarnEnabled();
        }
        LogEnabled enabled = LogEnabled.getInstance();
        if (null != enabled) {
            return enabled.isLevelEnabled(Level.WARN);
        }
        return this.wrapped.isWarnEnabled();
    }

    public void trace(Object arg0, Throwable arg1) {
        if (this.isTraceEnabled()) {
            this.wrapped.trace(arg0, arg1);
        }
    }

    public void trace(Object arg0) {
        if (this.isTraceEnabled()) {
            this.wrapped.trace(arg0);
        }
    }

    public void warn(Object arg0, Throwable arg1) {
        if (this.isWarnEnabled()) {
            this.wrapped.warn(arg0, arg1);
        }
    }

    public void warn(Object arg0) {
        if (this.isWarnEnabled()) {
            this.wrapped.warn(arg0);
        }
    }
}

