/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.expr.AbstractOperator;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.ExprException;
import com.dc.expr.Operator;

class SwitchOperator
extends AbstractOperator
implements Operator {
    public static SwitchOperator Op = new SwitchOperator();

    private SwitchOperator() {
    }

    public Exp eval(Exp[] children, ExprData data) {
        int len = children.length;
        int count = len / 2;
        for (int i = 0; i < count; ++i) {
            Exp exp1 = children[2 * i].eval();
            Exp exp2 = children[2 * i + 1].eval();
            ExpType type1 = exp1.getType();
            if (type1 != ExpType.BOOL_TYPE) {
                ExprException e = this.UnmatchType(this, type1);
                e.addScene("param-index", 2 * i);
            }
            if (!exp1.boolValue()) continue;
            return exp2;
        }
        Exp lastchild = children[len - 1].eval();
        return lastchild;
    }

    public ExpType getType(Exp[] children, ExprData data) {
        ExpType type1 = children[0].getType(data);
        ExpType type2 = children[1].getType(data);
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.INT_TYPE) {
            return type2;
        }
        throw this.UnmatchType(this, type1, type2);
    }

    public String toString() {
        return "Switch";
    }
}

