/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.expr.AbstractOperator;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.Operator;
import com.dc.expr.SExp;

class SubstrOperator
extends AbstractOperator
implements Operator {
    public static SubstrOperator Op = new SubstrOperator();

    private SubstrOperator() {
    }

    public Exp eval(Exp[] children, ExprData data) {
        Exp exp1 = children[0].eval(data);
        Exp exp2 = children[1].eval(data);
        Exp exp3 = children[2].eval(data);
        ExpType type1 = exp1.getType();
        ExpType type2 = exp2.getType();
        ExpType type3 = exp3.getType();
        if (type1 == ExpType.STR_TYPE && type2 == ExpType.INT_TYPE && type3 == ExpType.INT_TYPE) {
            String s = exp1.strValue();
            int start = exp2.intValue();
            int count = exp3.intValue();
            int len = s.length();
            if (start < 0) {
                start = 0;
            }
            if (start >= len) {
                return new SExp("");
            }
            if (count < 0) {
                count = len;
            }
            if (count + start > len) {
                return new SExp(s.substring(start));
            }
            return new SExp(s.substring(start, start + count));
        }
        throw this.UnmatchType(this, type1, type2, type3);
    }

    public ExpType getType(Exp[] children, ExprData data) {
        ExpType type1 = children[0].getType(data);
        ExpType type2 = children[1].getType(data);
        ExpType type3 = children[2].getType(data);
        if (type1 == ExpType.STR_TYPE && type2 == ExpType.INT_TYPE && type3 == ExpType.INT_TYPE) {
            return ExpType.STR_TYPE;
        }
        throw this.UnmatchType(this, type1, type2, type3);
    }

    public String toString() {
        return "substr";
    }
}

