/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.expr.AtomDataExp;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.ExprException;
import com.dc.expr.NotFoundExprException;
import com.dc.expr.VExp;

public class StructExp
extends VExp {
    private VExp struct;
    private String field;

    public StructExp(VExp struct, String field) {
        this.struct = struct;
        this.field = field;
    }

    public String getName() {
        if (this.struct == null) {
            return this.field;
        }
        return this.struct.getName() + "." + this.field;
    }

    public Exp eval(ExprData data) {
        if (this.struct == null && this.field != null) {
            AtomData atomdata = (AtomData)data.get(this.field);
            return new AtomDataExp(atomdata);
        }
        Exp exp1 = this.struct.eval(data);
        if (exp1.objectValue() == null) {
            CompositeData obs = new CompositeData();
            return new AtomDataExp(obs.getObject(this.field));
        }
        ExpType type1 = exp1.getType();
        if (type1 == ExpType.OBJECT_TYPE) {
            CompositeData obs = (CompositeData)exp1.objectValue();
            AtomData atomdata = obs.getObject(this.field);
            if (atomdata == null) {
                throw new NotFoundExprException(this.struct.strValue() + "." + this.field + "\u5728\u6570\u636e\u533a\u4e0d\u5b58\u5728");
            }
            return new AtomDataExp(atomdata);
        }
        throw new ExprException("not-struct-exp");
    }

    public String toString() {
        return "Struct";
    }
}

