/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.expr.AbstractOperator;
import com.dc.expr.DExp;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.Operator;

class Str2dblOperator
extends AbstractOperator
implements Operator {
    public static Str2dblOperator Op = new Str2dblOperator();

    private Str2dblOperator() {
    }

    public Exp eval(Exp[] children, ExprData data) {
        Exp exp1 = children[0].eval(data);
        ExpType type1 = exp1.getType();
        if (type1 == ExpType.STR_TYPE) {
            double i = 0.0;
            try {
                i = Double.parseDouble(exp1.strValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return new DExp(i);
        }
        throw this.UnmatchType(this, type1);
    }

    public ExpType getType(Exp[] children, ExprData data) {
        ExpType type1 = children[0].getType(data);
        if (type1 == ExpType.STR_TYPE) {
            return ExpType.DOUBLE_TYPE;
        }
        throw this.UnmatchType(this, type1);
    }

    public String toString() {
        return "str2dbl";
    }
}

