/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.expr.BExp;
import com.dc.expr.DExp;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprException;
import com.dc.expr.IExp;
import com.dc.expr.SExp;
import com.dc.expr.ValueExp;
import com.dc.expr.XExp;

class OExp
extends ValueExp {
    Object value;

    public OExp(Object value) {
        this.value = value;
    }

    public ExpType getType() {
        if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short || this.value instanceof Long) {
            return ExpType.INT_TYPE;
        }
        if (this.value instanceof Double || this.value instanceof Float) {
            return ExpType.DOUBLE_TYPE;
        }
        if (this.value instanceof String) {
            return ExpType.STR_TYPE;
        }
        if (this.value instanceof byte[]) {
            return ExpType.IMAGE_TYPE;
        }
        if (this.value instanceof Object[]) {
            return ExpType.ARRAY_TYPE;
        }
        if (this.value instanceof Object) {
            return ExpType.OBJECT_TYPE;
        }
        return ExpType.UNKNOWN_TYPE;
    }

    public Exp eval() {
        if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short || this.value instanceof Long) {
            return new IExp(((Number)this.value).intValue());
        }
        if (this.value instanceof Float) {
            return new DExp(((Float)this.value).floatValue());
        }
        if (this.value instanceof Double) {
            return new DExp((Double)this.value);
        }
        if (this.value instanceof String) {
            return new SExp(this.value.toString());
        }
        if (this.value instanceof Boolean) {
            return new BExp((Boolean)this.value);
        }
        if (this.value instanceof byte[]) {
            return new XExp((byte[])this.value);
        }
        throw new ExprException("unknown-object-type");
    }

    public int intValue() {
        if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short || this.value instanceof Long) {
            return ((Number)this.value).intValue();
        }
        throw new ExprException("not-int-object");
    }

    public double doubleValue() {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof Float) {
            return ((Float)this.value).floatValue();
        }
        throw new ExprException("not-double-object");
    }

    public String strValue() {
        if (this.value instanceof String) {
            return this.value.toString();
        }
        throw new ExprException("not-string-object");
    }

    public boolean boolValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new ExprException("not-bool-object");
    }

    public byte[] imageValue() {
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        throw new ExprException("not-image-object");
    }

    public Object objectValue() {
        if (this.value instanceof Object) {
            return this.value;
        }
        throw new ExprException("not-object");
    }

    public String toString() {
        return this.value.toString();
    }
}

