/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.expr.AbstractOperator;
import com.dc.expr.BExp;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.Operator;

class LEOperator
extends AbstractOperator
implements Operator {
    public static LEOperator Op = new LEOperator();

    private LEOperator() {
    }

    public Exp eval(Exp[] children, ExprData data) {
        Exp exp1 = children[0].eval(data);
        Exp exp2 = children[1].eval(data);
        ExpType type1 = exp1.getType();
        ExpType type2 = exp2.getType();
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.INT_TYPE) {
            return new BExp(exp1.intValue() <= exp2.intValue());
        }
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.DOUBLE_TYPE) {
            return new BExp(exp1.doubleValue() <= exp2.doubleValue());
        }
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.INT_TYPE) {
            return new BExp(exp1.doubleValue() <= (double)exp2.intValue());
        }
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.DOUBLE_TYPE) {
            return new BExp((double)exp1.intValue() <= exp2.doubleValue());
        }
        if (type1 == ExpType.STR_TYPE && type2 == ExpType.STR_TYPE) {
            return new BExp(exp1.strValue().compareTo(exp2.strValue()) <= 0);
        }
        throw this.UnmatchType(this, type1, type2);
    }

    public ExpType getType(Exp[] children, ExprData data) {
        ExpType type1 = children[0].getType(data);
        ExpType type2 = children[1].getType(data);
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.INT_TYPE) {
            return ExpType.BOOL_TYPE;
        }
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.DOUBLE_TYPE) {
            return ExpType.BOOL_TYPE;
        }
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.INT_TYPE) {
            return ExpType.BOOL_TYPE;
        }
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.DOUBLE_TYPE) {
            return ExpType.BOOL_TYPE;
        }
        if (type1 == ExpType.STR_TYPE && type2 == ExpType.STR_TYPE) {
            return ExpType.BOOL_TYPE;
        }
        throw this.UnmatchType(this, type1, type2);
    }

    public String toString() {
        return "<=";
    }
}

