/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.exception.BaseException;
import com.dc.expr.AbstractOperator;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.OExp;
import com.dc.expr.Operator;
import java.lang.reflect.Method;

class FuncOperator
extends AbstractOperator
implements Operator {
    private Class cls;
    private String method_name;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public static FuncOperator getFuncOperator(String name) {
        return new FuncOperator(name);
    }

    private FuncOperator(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid class/func name:" + name);
        }
        String clsname = name.substring(0, index);
        try {
            this.cls = Class.forName(clsname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cant load class:" + clsname);
        }
        this.method_name = name.substring(index + 1);
        Method[] methods = this.cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.method_name.equals(methods[i].getName())) continue;
            return;
        }
        throw new IllegalArgumentException("Cant find method:" + name);
    }

    public Exp eval(Exp[] children, ExprData data) {
        Object[] args = new Object[children.length];
        Class[] para = new Class[children.length];
        Exp[] exp = new Exp[children.length];
        for (int i = 0; i < children.length; ++i) {
            exp[i] = children[i].eval(data);
            ExpType type = exp[i].getType();
            if (type == ExpType.INT_TYPE) {
                args[i] = new Integer(exp[i].intValue());
                para[i] = Integer.TYPE;
                continue;
            }
            if (type == ExpType.BOOL_TYPE) {
                args[i] = new Boolean(exp[i].boolValue());
                para[i] = Boolean.TYPE;
                continue;
            }
            if (type == ExpType.DOUBLE_TYPE) {
                args[i] = new Double(exp[i].doubleValue());
                para[i] = Double.TYPE;
                continue;
            }
            if (type == ExpType.STR_TYPE) {
                args[i] = exp[i].strValue();
                para[i] = class$java$lang$String == null ? FuncOperator.class$("java.lang.String") : class$java$lang$String;
                continue;
            }
            if (type == ExpType.IMAGE_TYPE) {
                args[i] = exp[i].imageValue();
                para[i] = array$B == null ? FuncOperator.class$("[B") : array$B;
                continue;
            }
            if (type == ExpType.ARRAY_TYPE) {
                args[i] = exp[i].arrayValue();
                para[i] = array$Ljava$lang$Object == null ? FuncOperator.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object;
                continue;
            }
            if (type == ExpType.OBJECT_TYPE) {
                args[i] = exp[i].objectValue();
                para[i] = args[i].getClass();
                continue;
            }
            throw this.UnmatchType(this, type);
        }
        Method method = null;
        try {
            method = this.cls.getMethod(this.method_name, para);
        }
        catch (Exception e) {
            BaseException e1 = new BaseException("Unknown method", e);
            e1.addScene("Method", this.method_name);
            for (int i = 0; i < args.length; ++i) {
                e1.addScene("Para[" + i + "]", para[i]);
            }
            throw e1;
        }
        try {
            Object obj = method.invoke(null, args);
            return new OExp(obj);
        }
        catch (Exception e) {
            BaseException e1 = new BaseException("Invoke failed", e);
            e1.addScene("Method", method);
            for (int i = 0; i < args.length; ++i) {
                e1.addScene("Arg[" + i + "]", args[i]);
            }
            throw e1;
        }
    }

    public ExpType getType(Exp[] children, ExprData data) {
        throw this.UnmatchType(this, ExpType.UNKNOWN_TYPE);
    }

    public String toString() {
        return "Func";
    }
}

