/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.expr.AbstractOperator;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.Operator;
import com.dc.expr.SExp;

class Dbl2strOperator
extends AbstractOperator
implements Operator {
    public static Dbl2strOperator Op = new Dbl2strOperator();

    private Dbl2strOperator() {
    }

    public Exp eval(Exp[] children, ExprData data) {
        Exp exp1 = children[0].eval(data);
        Exp exp2 = children[1].eval(data);
        Exp exp3 = children[2].eval(data);
        ExpType type1 = exp1.getType();
        ExpType type2 = exp2.getType();
        ExpType type3 = exp3.getType();
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.INT_TYPE && type3 == ExpType.INT_TYPE) {
            String v = Double.toString(exp1.doubleValue());
            if (v.indexOf(".") > exp2.intValue() - exp3.intValue()) {
                v = v.substring(v.indexOf(".") - exp2.intValue() + exp3.intValue());
            }
            if (v.length() - v.indexOf(".") - 1 > exp3.intValue()) {
                v = v.substring(0, v.indexOf(".") + 1 + exp3.intValue());
            }
            String space = "";
            for (int i = 0; i < exp2.intValue() - exp3.intValue() - v.indexOf("."); ++i) {
                space = space + "0";
            }
            String zero = "";
            for (int j = 0; j < exp3.intValue() - (v.length() - v.indexOf(".")) + 1; ++j) {
                zero = zero + "0";
            }
            String value = space + v + zero;
            return new SExp(value);
        }
        throw this.UnmatchType(this, type1);
    }

    public ExpType getType(Exp[] children, ExprData data) {
        ExpType type1 = children[0].getType(data);
        ExpType type2 = children[1].getType(data);
        ExpType type3 = children[2].getType(data);
        if (type1 == ExpType.STR_TYPE && type2 == ExpType.INT_TYPE && type3 == ExpType.INT_TYPE) {
            return ExpType.STR_TYPE;
        }
        throw this.UnmatchType(this, type1, type2, type3);
    }

    public String toString() {
        return "dbl2str";
    }
}

