/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.CompositeDataSet;
import com.dc.expr.ExprData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeDataExprData
implements ExprData {
    private static Log log = LogFactory.getLog((Class)CompositeDataExprData.class);
    private CompositeDataSet set;

    public CompositeDataExprData(CompositeDataSet set) {
        this.set = set;
    }

    public CompositeDataExprData(CompositeData data) {
        this.set = new CompositeDataSet();
        this.set.putData("temp", data);
    }

    public Object get(String name) {
        return this.getAtomData(name);
    }

    private AtomData getAtomData(String fullName) {
        CompositeData out;
        if (fullName == null || fullName.equals("")) {
            return null;
        }
        int idx = fullName.indexOf(".");
        if (idx >= 0) {
            String subname = fullName.substring(idx + 1);
            CompositeData data = this.set.getData(fullName.substring(0, idx));
            if (data == null) {
                String data_name = fullName.substring(0, idx + subname.indexOf(".") + 1);
                subname = subname.substring(subname.indexOf(".") + 1);
                data = this.set.getData(data_name);
                if (data != null) {
                    return data.getObject(subname);
                }
            } else {
                return data.getObject(fullName.substring(idx + 1));
            }
        }
        if ((out = this.set.getData(fullName)) != null) {
            return out;
        }
        CompositeData currentdata = this.set.getCurrentData();
        AtomData obj = currentdata.getObject(fullName);
        if (obj != null) {
            return obj;
        }
        CompositeData in_data = this.set.getPreviousData();
        obj = in_data.getObject(fullName);
        if (obj != null) {
            return obj;
        }
        CompositeData previousdata = this.set.getDefaultData();
        obj = previousdata.getObject(fullName);
        if (obj != null) {
            return obj;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)(fullName + "\u5728\u6570\u636e\u533a\u96c6\u5408\u4e2d\u4e0d\u5b58\u5728"));
        }
        return null;
    }

    private String splitPrefix(String fullName) {
        String temp = this.checkToken(fullName, "default", true);
        if (temp == null) {
            temp = this.checkToken(fullName, "in", true);
        }
        if (temp == null) {
            temp = this.checkToken(fullName, ".in");
        }
        if (temp == null) {
            temp = this.checkToken(fullName, "out", true);
        }
        if (temp == null) {
            temp = this.checkToken(fullName, ".out");
        }
        if (temp == null) {
            temp = this.checkToken(fullName, "temp", true);
        }
        if (temp == null) {
            temp = this.checkToken(fullName, "");
        }
        return temp;
    }

    private String checkToken(String str, String token, boolean equal) {
        int idx = str.indexOf(token + ".");
        if (equal ? idx == 0 : idx >= 0) {
            return str.substring(0, idx + token.length());
        }
        return null;
    }

    private String checkToken(String str, String token) {
        return this.checkToken(str, token, false);
    }
}

