/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldType;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.ExprException;
import com.dc.expr.VExp;

class AtomDataExp
extends VExp {
    AtomData value;
    String name;

    public AtomDataExp(AtomData value) {
        this.value = value;
    }

    public AtomDataExp(String name) {
        this.name = name;
    }

    public AtomDataExp(String name, AtomData value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Exp eval() {
        return this;
    }

    public Exp eval(ExprData data) {
        AtomData atom = null;
        Object obj = data.get(this.name);
        if (obj != null) {
            atom = (AtomData)data.get(this.name);
            return new AtomDataExp(this.name, atom);
        }
        return new AtomDataExp(this.name, atom);
    }

    public ExpType getType() {
        if (this.value == null) {
            return ExpType.UNKNOWN_TYPE;
        }
        if (this.value.isField()) {
            Field field = (Field)this.value;
            FieldType type = field.getFieldType();
            if (FieldType.integerType(type)) {
                return ExpType.INT_TYPE;
            }
            if (FieldType.decimalType(type)) {
                return ExpType.DOUBLE_TYPE;
            }
            if (FieldType.stringType(type)) {
                return ExpType.STR_TYPE;
            }
            return ExpType.IMAGE_TYPE;
        }
        return ExpType.OBJECT_TYPE;
    }

    public ExpType getType(ExprData data) {
        return this.getType();
    }

    public int intValue() {
        this.valueIsNull();
        if (this.value.isField()) {
            return ((Field)this.value).intValue();
        }
        throw new ExprException("not-field-exp");
    }

    public double doubleValue() {
        this.valueIsNull();
        if (this.value.isField()) {
            return ((Field)this.value).doubleValue();
        }
        throw new ExprException("not-field-exp");
    }

    public boolean boolValue() {
        this.valueIsNull();
        if (this.value.isField()) {
            int v = ((Field)this.value).intValue();
            return v != 0;
        }
        throw new ExprException("not-field-exp");
    }

    public String strValue() {
        this.valueIsNull();
        if (this.value.isField()) {
            return ((Field)this.value).strValue();
        }
        throw new ExprException("not-field-exp");
    }

    public void valueIsNull() {
        if (this.value == null) {
            throw new ExprException("not-value-exp");
        }
    }

    public byte[] imageValue() {
        this.valueIsNull();
        if (this.value.isField()) {
            return ((Field)this.value).imageValue();
        }
        throw new ExprException("not-field-exp");
    }

    public Object objectValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value != null) {
            return this.value;
        }
        throw new ExprException("not-struct-exp");
    }

    public Object[] arrayValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value.isArray()) {
            Array array = (Array)this.value;
            if (array.size() > 0) {
                Object[] values = new Object[array.size()];
                AtomData item = array.getObject(0);
                if (item.isField()) {
                    for (int i = 0; i < array.size(); ++i) {
                        Field fld = array.getField(i);
                        FieldType ftype = fld.getFieldType();
                        if (FieldType.integerType(ftype)) {
                            if (FieldType.FIELD_BYTE == ftype) {
                                values[i] = new Integer(fld.intValue());
                                continue;
                            }
                            if (FieldType.FIELD_INT24 == ftype) {
                                values[i] = new Integer(fld.intValue());
                                continue;
                            }
                            if (FieldType.FIELD_INT == ftype) {
                                values[i] = new Integer(fld.intValue());
                                continue;
                            }
                            if (FieldType.FIELD_LONG != ftype) continue;
                            values[i] = new Integer(fld.intValue());
                            continue;
                        }
                        if (FieldType.decimalType(ftype)) {
                            if (FieldType.FIELD_FLOAT == ftype) {
                                values[i] = new Double(fld.doubleValue());
                                continue;
                            }
                            if (FieldType.FIELD_DOUBLE != ftype) continue;
                            values[i] = new Double(fld.doubleValue());
                            continue;
                        }
                        if (ftype == FieldType.FIELD_STRING) {
                            values[i] = fld.strValue();
                            continue;
                        }
                        if (ftype != FieldType.FIELD_IMAGE) continue;
                        values[i] = fld.imageValue();
                    }
                } else {
                    for (int i = 0; i < array.size(); ++i) {
                        values[i] = array.getObject(i);
                    }
                }
                return values;
            }
            return new Object[0];
        }
        throw new ExprException("not-array-exp");
    }
}

