/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.expr.AtomDataExp;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.ExprException;
import com.dc.expr.VExp;

public class ArrayExp
extends VExp {
    private VExp array;
    private Exp index;

    public ArrayExp(VExp parent, Exp child) {
        this.array = parent;
        this.index = child;
    }

    public String getName() {
        return this.array.getName() + "[" + this.index.intValue() + "]";
    }

    public Exp eval(ExprData data) {
        Exp exp1 = this.array.eval(data);
        Exp exp2 = this.index.eval(data);
        if (exp1.objectValue() == null) {
            Array obs = new Array();
            return new AtomDataExp(obs.getObject(exp2.intValue()));
        }
        ExpType type1 = exp1.getType();
        ExpType type2 = exp2.getType();
        if (type1 == ExpType.OBJECT_TYPE && type2 == ExpType.INT_TYPE) {
            Array obs = (Array)exp1.objectValue();
            AtomData atomdata = obs.getObject(exp2.intValue());
            return new AtomDataExp(atomdata);
        }
        throw new ExprException("not-array-exp");
    }

    public String toString() {
        return "Array";
    }
}

