/*
 * Decompiled with CFR 0.152.
 */
package com.dc.expr;

import com.dc.expr.AbstractOperator;
import com.dc.expr.DExp;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprData;
import com.dc.expr.IExp;
import com.dc.expr.Operator;
import com.dc.expr.SExp;

class AddOperator
extends AbstractOperator
implements Operator {
    public static AddOperator Op = new AddOperator();

    private AddOperator() {
    }

    public Exp eval(Exp[] children, ExprData data) {
        Exp exp1 = children[0].eval(data);
        Exp exp2 = children[1].eval(data);
        ExpType type1 = exp1.getType();
        ExpType type2 = exp2.getType();
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.INT_TYPE) {
            return new IExp(exp1.intValue() + exp2.intValue());
        }
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.DOUBLE_TYPE) {
            return new DExp(exp1.doubleValue() + exp2.doubleValue());
        }
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.INT_TYPE) {
            return new DExp(exp1.doubleValue() + (double)exp2.intValue());
        }
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.DOUBLE_TYPE) {
            return new DExp((double)exp1.intValue() + exp2.doubleValue());
        }
        if (type1 == ExpType.STR_TYPE && type2 == ExpType.STR_TYPE) {
            return new SExp(exp1.strValue() + exp2.strValue());
        }
        throw this.UnmatchType(this, type1, type2);
    }

    public ExpType getType(Exp[] children, ExprData data) {
        ExpType type1 = children[0].getType(data);
        ExpType type2 = children[1].getType(data);
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.INT_TYPE) {
            return ExpType.INT_TYPE;
        }
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.DOUBLE_TYPE) {
            return ExpType.DOUBLE_TYPE;
        }
        if (type1 == ExpType.DOUBLE_TYPE && type2 == ExpType.INT_TYPE) {
            return ExpType.DOUBLE_TYPE;
        }
        if (type1 == ExpType.INT_TYPE && type2 == ExpType.DOUBLE_TYPE) {
            return ExpType.DOUBLE_TYPE;
        }
        if (type1 == ExpType.STR_TYPE && type2 == ExpType.STR_TYPE) {
            return ExpType.STR_TYPE;
        }
        throw this.UnmatchType(this, type1, type2);
    }

    public String toString() {
        return "Add";
    }
}

